/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.ui.swt.base.textsearch.IndexBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.TableItem;

public final class PropertyTableViewerBasedTextSearchHandler
extends IndexBasedTextSearchHandler<TableItem> {
    private final PropertyTableViewer<?> m_propertyTableViewer;

    public PropertyTableViewerBasedTextSearchHandler(PropertyTableViewer<?> propertyTableViewer, String connectedTo) {
        super(connectedTo);
        assert (propertyTableViewer != null) : "Parameter 'propertyTableViewer' of method 'PropertyTableViewerBasedTextSearchProvider' must not be null";
        this.m_propertyTableViewer = propertyTableViewer;
    }

    @Override
    public boolean canConnect() {
        return !this.m_propertyTableViewer.isDisposed();
    }

    @Override
    public List<TableItem> getSortedElementsForSearch() {
        return Arrays.asList(this.m_propertyTableViewer.getTable().getItems());
    }

    @Override
    public void selectAndRevealForFind(TableItem elementToSelectAndReveal) {
        assert (elementToSelectAndReveal != null) : "Parameter 'elementToSelectAndReveal' of method 'selectAndRevealForFind' must not be null";
        this.m_propertyTableViewer.getTable().setSelection(elementToSelectAndReveal);
    }

    @Override
    protected String getTextForTextSearch(TableItem elementForTextSearch) {
        assert (elementForTextSearch != null) : "Parameter 'elementForTextSearch' of method 'getTextForTextSearch' must not be null";
        if (elementForTextSearch.isDisposed()) {
            return " ";
        }
        int columnCount = elementForTextSearch.getParent().getColumnCount();
        StringBuilder textContent = new StringBuilder();
        int i = 0;
        while (i < columnCount) {
            String columnText = elementForTextSearch.getText(i);
            if (!columnText.isEmpty()) {
                textContent.append(columnText);
                textContent.append(" ");
            }
            ++i;
        }
        return textContent.toString();
    }

    @Override
    protected int calculatePositionForFind() {
        int selectionIndex = this.m_propertyTableViewer.getTable().getSelectionIndex();
        selectionIndex = Math.max(0, selectionIndex);
        return selectionIndex;
    }
}

