/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.graph.GraphMode;
import com.hello2morrow.sonargraph.core.model.graph.IGraphRepresentationProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.RepresentationViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import java.util.List;

final class GraphViewShowInViewSupport
extends RepresentationViewShowInViewSupport {
    GraphViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        if (WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED)) {
            List<Element> elementsForShowInView = this.getElementsForShowInView(selectedElements);
            if (secondaryIdForReuse != null && elementsForShowInView.size() == 1 && elementsForShowInView.get(0) instanceof OnDemandCycleGroup) {
                return null;
            }
            if (elementsForShowInView.size() == 1 && elementsForShowInView.get(0) instanceof CycleGroup) {
                return null;
            }
            ShowInView showInView = super.supportsShowInViewFor(selectedElements, options, secondaryIdForReuse);
            List elementsForTypeBasedGraph = ((IGraphRepresentationProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IGraphRepresentationProvider.class)).getElementsForTypeBasedGraphShowInView(selectedElements);
            if (!elementsForTypeBasedGraph.isEmpty()) {
                String secondaryId = this.getNextOrReusedSecondaryId(secondaryIdForReuse);
                ShowInViewNode typeGraphIncludingNestedTypesMenuEntry = new ShowInViewNode(elementsForTypeBasedGraph, "Show in Graph View (Type-Based)", "Type", false, secondaryId);
                typeGraphIncludingNestedTypesMenuEntry.addOption((IStandardEnumeration)GraphMode.TYPE_BASED_INCLUDING_NESTED_TYPES);
                this.adjustShowInViewOptions(typeGraphIncludingNestedTypesMenuEntry, options, this.getDefaultPresentationMode());
                this.addFocusBasedSubMenuEntries(typeGraphIncludingNestedTypesMenuEntry);
                ShowInViewNode typeGraphExcludingNestedTypesMenuEntry = new ShowInViewNode(elementsForTypeBasedGraph, "Show in Graph View (Type-Based Excluding Nested Types)", "Type", false, secondaryId);
                typeGraphExcludingNestedTypesMenuEntry.addOption((IStandardEnumeration)GraphMode.TYPE_BASED_EXCLUDING_NESTED_TYPES);
                this.adjustShowInViewOptions(typeGraphExcludingNestedTypesMenuEntry, options, this.getDefaultPresentationMode());
                this.addFocusBasedSubMenuEntries(typeGraphExcludingNestedTypesMenuEntry);
                showInView.addRootNode(typeGraphExcludingNestedTypesMenuEntry);
                showInView.addRootNode(typeGraphIncludingNestedTypesMenuEntry);
            }
            return showInView;
        }
        return null;
    }

    @Override
    protected void adjustShowInViewOptions(ShowInViewNode showInViewMenuEntryModel, List<IStandardEnumeration> options, PresentationMode defaultPresentationMode) {
        assert (options != null) : "Parameter 'options' of method 'adjustShowInViewOptions' must not be null";
        IStandardEnumeration presentationMode = null;
        for (IStandardEnumeration option : options) {
            if (!(option instanceof PresentationMode)) continue;
            presentationMode = option;
            break;
        }
        if (presentationMode != null && presentationMode == PresentationMode.MIXED) {
            assert (defaultPresentationMode != PresentationMode.MIXED) : String.valueOf(defaultPresentationMode) + " is not supported for Graph View";
            options.add((IStandardEnumeration)defaultPresentationMode);
        }
        super.adjustShowInViewOptions(showInViewMenuEntryModel, options, defaultPresentationMode);
    }

    @Override
    public PresentationMode getDefaultPresentationMode() {
        return PresentationMode.HIERARCHICAL;
    }
}

