/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.wizard;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StandardWizardPage
extends SonargraphWizardPage {
    private static HelpAdapter s_helpAdapter;

    protected StandardWizardPage(String pageName) {
        super(pageName);
    }

    protected StandardWizardPage(String pageName, String title) {
        super(pageName, title);
    }

    public static final void setHelpAdapter(HelpAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'setHelpAdapter' must not be null";
        s_helpAdapter = adapter;
    }

    public static final void resetHelpAdapter() {
        s_helpAdapter = null;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected boolean getColumnsEqualWidth() {
        return false;
    }

    protected abstract void createContent(Composite var1);

    @Override
    public final void createControl(Composite parent) {
        TrayDialog trayDialog;
        assert (parent != null) : "Parameter 'parent' of method 'createControl' must not be null";
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(this.getNumberOfColumns(), this.getColumnsEqualWidth()));
        this.createContent(composite);
        this.setControl((Control)composite);
        if (this.getDialogId() != null && s_helpAdapter != null && (trayDialog = this.getTrayDialog()) != null) {
            s_helpAdapter.register(trayDialog, null, (Object)this, this.getDialogId().getId());
        }
        super.createControl(parent);
    }

    public final void performHelp() {
        TrayDialog dialog;
        if (this.getDialogId() != null && (dialog = this.getTrayDialog()) != null) {
            if (dialog.getTray() == null) {
                if (s_helpAdapter != null) {
                    s_helpAdapter.showHelp(dialog, (Object)this);
                }
            } else {
                dialog.closeTray();
            }
        }
    }

    private TrayDialog getTrayDialog() {
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof TrayDialog) {
            return (TrayDialog)container;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Shell shell;
            TrayDialog dialog;
            if (this.getDialogId() != null && (dialog = this.getTrayDialog()) != null && dialog.getTray() != null && s_helpAdapter != null) {
                s_helpAdapter.showHelp(dialog, (Object)this);
            }
            if (Platform.isMac() && (shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.setRedraw(false);
                shell.redraw();
                shell.layout(true, true);
                shell.forceFocus();
                shell.setRedraw(true);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.getDialogId() != null && HelpAdapter.getHelpAdapter() != null) {
            HelpAdapter.getHelpAdapter().unregister((Object)this);
        }
        super.dispose();
    }
}

