/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.wizard;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardDialog;
import java.util.List;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class SonargraphWizardAdapter {
    public static WizardDialog createWizardDialog(Shell shell, SonargraphWizard wizard) {
        assert (shell != null) : "Parameter 'shell' of method 'create' must not be null";
        assert (wizard != null) : "Parameter 'wizard' of method 'create' must not be null";
        SonargraphWizardDialog dialog = new SonargraphWizardDialog(shell, wizard, wizard.showHelpIcon());
        dialog.setPageSize(wizard.getPreferredWidth(), wizard.getPreferredHeight());
        dialog.setMinimumPageSize(wizard.getMinimumWidth(), wizard.getMinimumHeight());
        return dialog;
    }

    public abstract String getBundleId();

    public abstract String getName();

    public abstract Category getCategory();

    public abstract String getImageResource();

    public abstract boolean isAvailable();

    public abstract boolean isEnabled(ISoftwareSystemProvider var1, List<Element> var2);

    public boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        return true;
    }

    public abstract SonargraphWizard create(ISoftwareSystemProvider var1, List<Element> var2);

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SonargraphWizardAdapter other = (SonargraphWizardAdapter)obj;
        return this.getName().equals(other.getName());
    }

    public static final class Category
    extends Enum<Category>
    implements IStandardEnumeration {
        public static final /* enum */ Category CONFIGURATION = new Category("Installation");
        public static final /* enum */ Category SYSTEM = new Category("NewSoftwareSystem");
        public static final /* enum */ Category MODULE = new Category("NewModule");
        public static final /* enum */ Category ROOT_DIRECTORY = new Category("NewDirectoryPath");
        public static final /* enum */ Category WORKSPACE = new Category("WorkspaceProfile");
        public static final /* enum */ Category MODEL = new Category("SetModifiableModel");
        public static final /* enum */ Category ARCHITECTURAL_VIEW = new Category("ArchitecturalView");
        public static final /* enum */ Category ARCHITECTURE = new Category("ArchitectureView");
        public static final /* enum */ Category SCRIPT = new Category("GroovyScript");
        public static final /* enum */ Category QualityGate = new Category("QualityGate");
        public static final /* enum */ Category OTHER = new Category("Other");
        private final String m_imageResource;
        private static final /* synthetic */ Category[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Category[]{CONFIGURATION, SYSTEM, MODULE, ROOT_DIRECTORY, WORKSPACE, MODEL, ARCHITECTURAL_VIEW, ARCHITECTURE, SCRIPT, QualityGate, OTHER};
        }

        private Category(String imageResource) {
            assert (imageResource != null && imageResource.length() > 0) : "Parameter 'imageResource' of method 'Category' must not be empty";
            this.m_imageResource = imageResource;
        }

        public String getImageResource() {
            return this.m_imageResource;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public static Category[] values() {
            Category[] categoryArray = ENUM$VALUES;
            int n = categoryArray.length;
            Category[] categoryArray2 = new Category[n];
            System.arraycopy(ENUM$VALUES, 0, categoryArray2, 0, n);
            return categoryArray2;
        }

        public static Category valueOf(String string) {
            return Enum.valueOf(Category.class, string);
        }
    }
}

