/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.MessageDialogWithContent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class TextFilterWidget
extends Composite {
    private final Text m_filterTextField;
    private boolean m_isRegex = false;

    public TextFilterWidget(Composite parent, ITextFilterCallback callback) {
        this(parent, callback, null);
    }

    public TextFilterWidget(Composite parent, final ITextFilterCallback callback, final IRegexFilterCallback regexCallback) {
        super(parent, 0);
        assert (callback != null) : "Parameter 'callback' of method 'TextFilterWidget' must not be null";
        GridLayout filterLayout = new GridLayout(regexCallback != null ? 4 : 3, false);
        filterLayout.marginHeight = 0;
        filterLayout.horizontalSpacing = 5;
        filterLayout.verticalSpacing = 0;
        filterLayout.marginWidth = 0;
        this.setLayout((Layout)filterLayout);
        this.m_filterTextField = new Text((Composite)this, 2948);
        this.m_filterTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.m_filterTextField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                if (event.detail == 256) {
                    TextFilterWidget.this.callbackClient(callback, regexCallback, "");
                } else {
                    TextFilterWidget.this.callbackClient(callback, regexCallback, TextFilterWidget.this.getFilterTextInput());
                }
            }
        });
        this.m_filterTextField.addTraverseListener(e -> {
            switch (e.detail) {
                case 2: 
                case 4: {
                    e.doit = false;
                }
            }
        });
        if (regexCallback != null) {
            Button isRegexButton = new Button((Composite)this, 32);
            isRegexButton.setText("Regex");
            isRegexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button btn = (Button)event.getSource();
                    TextFilterWidget.this.m_isRegex = btn.getSelection();
                }
            });
        }
        int height = SwtUtility.calculatePreferredHeight(this.m_filterTextField, 1) + 2;
        Button filterButton = new Button((Composite)this, 8);
        filterButton.setToolTipText("Apply text as filter to shown elements");
        filterButton.setImage(UiResourceManager.getInstance().getImage("Apply"));
        filterButton.setLayoutData((Object)this.createFilterButtonGridData(height));
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFilterWidget.this.callbackClient(callback, regexCallback, TextFilterWidget.this.getFilterTextInput());
            }
        });
    }

    private void callbackClient(ITextFilterCallback callback, IRegexFilterCallback regexCallback, String text) {
        if (this.m_isRegex) {
            assert (regexCallback != null) : "Parameter 'regexCallback' of method 'callbackClient' must not be null";
            try {
                Pattern regex = Pattern.compile(this.getFilterTextInput());
                regexCallback.applyRegexFilter(regex);
            }
            catch (PatternSyntaxException e) {
                new MessageDialogWithContent(this.getShell(), "Error in Regex", 1, e.getDescription()).open();
                return;
            }
        } else {
            callback.applyTextFilter(this.getFilterTextInput());
        }
    }

    public Text getFilterText() {
        return this.m_filterTextField;
    }

    public String getFilterTextInput() {
        return this.m_filterTextField.getText();
    }

    private GridData createFilterButtonGridData(int height) {
        GridData filterButtonGridData = new GridData(0x1000000, 0x1000000, false, false);
        if (Platform.isWindows()) {
            filterButtonGridData.heightHint = height;
            filterButtonGridData.widthHint = height;
        }
        return filterButtonGridData;
    }

    public static interface IRegexFilterCallback {
        public void applyRegexFilter(Pattern var1);
    }

    public static interface ITextFilterCallback {
        public void applyTextFilter(String var1);
    }
}

