/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SourceViewIdFilter {
    private final Mode m_mode;
    private final List<IViewId> m_sourceViewIds;

    public SourceViewIdFilter(Mode mode, IViewId ... sourceViewIds) {
        assert (mode != null) : "Parameter 'mode' of method 'SourceViewIdFilter' must not be null";
        assert (sourceViewIds != null && sourceViewIds.length > 0) : "Parameter 'sourceViewIds' of method 'SourceViewIdFilter' must not be empty";
        this.m_mode = mode;
        this.m_sourceViewIds = new ArrayList<IViewId>(Arrays.asList(sourceViewIds));
    }

    public boolean sourceIsPossible(IViewId sourceViewId) {
        switch (this.m_mode) {
            case EXCLUDE: {
                return !this.m_sourceViewIds.contains(sourceViewId);
            }
            case INCLUDE: {
                return this.m_sourceViewIds.contains(sourceViewId);
            }
        }
        assert (false) : "Unhandled: " + String.valueOf((Object)this.m_mode);
        return false;
    }

    public static enum Mode {
        INCLUDE,
        EXCLUDE;

    }
}

