/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectionProviderAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionProviderAdapter.class);
    private final IWorkbenchView m_workbenchView;
    private final ESelectionService m_selectionService;
    private final IEclipseContext m_eclipseContext;

    public static final List<Element> getElementsFromSelection(IStructuredSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'getElementsFromSelection' must not be null";
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSelection = selection;
            List list = structuredSelection.toList();
            ArrayList<Element> elements = new ArrayList<Element>(list.size());
            for (Object next : list) {
                if (next instanceof Element) {
                    elements.add((Element)next);
                    continue;
                }
                LOGGER.warn("Unexpected element class in selection: " + String.valueOf(next));
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public SelectionProviderAdapter(IWorkbenchView provider, ESelectionService selectionService, IEclipseContext eclipseContext) {
        assert (provider != null) : "Parameter 'provider' of method 'SelectionProviderAdapter' must not be null";
        assert (selectionService != null) : "Parameter 'selectionService' of method 'SelectionProviderAdapter' must not be null";
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'SelectionProviderAdapter' must not be null";
        this.m_workbenchView = provider;
        this.m_selectionService = selectionService;
        this.m_eclipseContext = eclipseContext;
    }

    public ESelectionService getSelectionService() {
        return this.m_selectionService;
    }

    public List<Element> getCurrentSelection() {
        Object selection = this.m_selectionService.getSelection();
        if (selection instanceof WorkbenchViewSelection) {
            return ((WorkbenchViewSelection)selection).getElements();
        }
        if (selection != null) {
            LOGGER.debug("Unexpected selection: " + selection.getClass().getName());
        }
        return Collections.emptyList();
    }

    public WorkbenchViewSelection getCurrentWorkbenchViewSelection() {
        Object selection = this.m_selectionService.getSelection();
        if (selection instanceof WorkbenchViewSelection) {
            return (WorkbenchViewSelection)selection;
        }
        if (selection != null) {
            LOGGER.debug("Unexpected selection: " + selection.getClass().getName());
        }
        return null;
    }

    public void handleSelectionChanged(List<Element> selected) {
        assert (selected != null) : "Parameter 'selected' of method 'handleSelectionChanged' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Propagating selection to selection service [" + String.valueOf(this.m_workbenchView) + "]: " + selected.size() + " element(s)");
            for (Element element : selected) {
                LOGGER.debug(element.toString());
            }
        }
        this.m_selectionService.setSelection((Object)new WorkbenchViewSelection(this.m_workbenchView, selected));
        for (IWorkbenchView iWorkbenchView : RcpUtility.getWorkbenchViews(this.m_eclipseContext)) {
            if (this.m_workbenchView == iWorkbenchView || !iWorkbenchView.isActive()) continue;
            iWorkbenchView.viewSelectionChanged(this.m_workbenchView, selected);
        }
    }

    public void handleSelectionChanged() {
        assert (this.m_workbenchView != null) : "Parameter 'm_provider' of method 'handleSelectionChanged' must not be null";
        this.handleSelectionChanged(Collections.emptyList());
    }

    public void handleSelectionChanged(Element selected) {
        if (selected != null) {
            this.handleSelectionChanged(Arrays.asList(selected));
        } else {
            this.handleSelectionChanged();
        }
    }

    public void handleSelectionChanged(IStructuredSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'handleSelectionChanged' must not be null";
        this.handleSelectionChanged(SelectionProviderAdapter.getElementsFromSelection(selection));
    }

    public List<Element> getElementList(Element element) {
        return element == null ? Collections.emptyList() : Collections.singletonList(element);
    }
}

