/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeTextFilterWidget;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeViewerTextFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilteredTreeViewer<T>
extends Composite {
    private final TreeViewer m_treeViewer;
    private final TreeTextFilterWidget m_filterComposite;
    private final GridData m_filterLayoutData;
    private final Predicate<T> m_leafPredicate;
    private final Function<T, Collection<T>> m_childrenProvider;
    private final Class<T> m_clazz;
    private final int m_autoExpandLevel;

    public FilteredTreeViewer(Composite parent, int style, Class<T> clazz, Predicate<T> leafPredicate, Function<T, Collection<T>> childrenProvider, int autoExpandLevel) {
        super(parent, 0);
        assert (clazz != null) : "Parameter 'clazz' of method 'FilteredTreeViewer' must not be null";
        assert (leafPredicate != null) : "Parameter 'leafPredicate' of method 'FilteredTreeViewer' must not be null";
        assert (childrenProvider != null) : "Parameter 'childrenProvider' of method 'FilteredTreeViewer' must not be null";
        this.m_clazz = clazz;
        this.m_leafPredicate = leafPredicate;
        this.m_childrenProvider = childrenProvider;
        this.m_autoExpandLevel = autoExpandLevel;
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        this.m_filterComposite = new TreeTextFilterWidget(this, new TreeTextFilterWidget.ITextFilterCallback(){

            @Override
            public void applyTextFilter(String text, boolean leafsOnly) {
                FilteredTreeViewer.this.applyTextFilter(text, leafsOnly);
            }
        });
        this.m_treeViewer = new TreeViewer((Composite)this, style);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_filterLayoutData = new GridData(4, 4, true, false);
        this.m_filterComposite.setLayoutData(this.m_filterLayoutData);
        this.m_filterComposite.getFilterText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    FilteredTreeViewer.this.toggleVisibilityOfTextFilter(FilteredTreeViewer.this.m_filterLayoutData, FilteredTreeViewer.this.m_filterComposite.getFilterText(), false);
                }
            }
        });
        this.m_filterLayoutData.exclude = true;
        this.m_filterComposite.setVisible(false);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && (e.stateMask & 0x20000) == 131072 && e.keyCode == 102) {
                    FilteredTreeViewer.this.toggleVisibilityOfTextFilter(FilteredTreeViewer.this.m_filterLayoutData, FilteredTreeViewer.this.m_filterComposite.getFilterText(), true);
                } else if (e.keyCode == 27) {
                    FilteredTreeViewer.this.toggleVisibilityOfTextFilter(FilteredTreeViewer.this.m_filterLayoutData, FilteredTreeViewer.this.m_filterComposite.getFilterText(), false);
                }
            }
        };
        this.m_treeViewer.getTree().addKeyListener((KeyListener)keyListener);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    private void toggleVisibilityOfTextFilter(GridData filterLayoutData, Text filterTextField, boolean show) {
        boolean doIt;
        assert (filterLayoutData != null) : "Parameter 'filterLayoutData' of method 'toggleVisibilityOfTextFilter' must not be null";
        boolean bl = doIt = show && !this.m_filterComposite.isVisible() || !show && this.m_filterComposite.isVisible();
        if (doIt) {
            this.m_treeViewer.getTree().setRedraw(false);
            this.m_filterComposite.setVisible(show);
            filterLayoutData.exclude = !show;
            this.layout(true);
            if (show) {
                assert (filterTextField != null) : "Parameter 'filterTextField' of method 'toggleVisibilityOfTextFilter' must not be null";
                filterTextField.setFocus();
                filterTextField.setSelection(0, filterTextField.getText().length());
            } else {
                this.applyTextFilter("", false);
            }
            this.m_treeViewer.getTree().setRedraw(true);
        }
    }

    private void applyTextFilter(String filterText, boolean leafsOnly) {
        assert (filterText != null) : "Parameter 'filterText' of method 'applyTextFilter' must not be null";
        ArrayList<ViewerFilter> previousFilters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.m_treeViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter next = viewerFilterArray[n2];
            if (next instanceof AggregatingViewerFilter) {
                previousFilters.addAll(((AggregatingViewerFilter)next).getFilters());
            } else {
                previousFilters.add(next);
            }
            ++n2;
        }
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        for (ViewerFilter next : previousFilters) {
            if (next instanceof TreeViewerTextFilter) continue;
            filters.add(next);
        }
        if (!filterText.isEmpty() && !filterText.trim().isEmpty()) {
            ArrayList<ILabelProvider> labelProviders = new ArrayList<ILabelProvider>();
            int columnCount = this.m_treeViewer.getTree().getColumnCount();
            if (columnCount == 0) {
                labelProviders.add((ILabelProvider)this.m_treeViewer.getLabelProvider());
            } else {
                int i = 0;
                while (i < columnCount) {
                    labelProviders.add((ILabelProvider)this.m_treeViewer.getLabelProvider(i));
                    ++i;
                }
            }
            EnumSet<TreeViewerTextFilter.Option> options = leafsOnly ? EnumSet.of(TreeViewerTextFilter.Option.FILTER_LEAFS_ONLY) : EnumSet.noneOf(TreeViewerTextFilter.Option.class);
            TreeViewerTextFilter<T> textFilter = new TreeViewerTextFilter<T>(this.m_clazz, filterText, options, labelProviders, this.m_leafPredicate, this.m_childrenProvider);
            filters.add(textFilter);
        }
        this.m_treeViewer.getControl().setRedraw(false);
        if (filters.isEmpty()) {
            this.m_treeViewer.collapseAll();
            this.m_treeViewer.resetFilters();
            this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
            if (this.m_autoExpandLevel == -1) {
                this.m_treeViewer.expandAll();
            } else {
                this.m_treeViewer.expandToLevel(this.m_autoExpandLevel);
            }
        } else {
            AggregatingViewerFilter filter = new AggregatingViewerFilter(filters);
            this.m_treeViewer.setFilters(new ViewerFilter[]{filter});
            Color background = filter.hasHiddenElements() ? UiResourceManager.getInstance().getViewHasFilteredElementsColor() : UiResourceManager.getInstance().getBackgroundColor();
            this.m_treeViewer.getTree().setBackground(background);
            this.m_treeViewer.expandAll();
        }
        this.m_treeViewer.getControl().setRedraw(true);
    }

    public void showData(T root) {
        this.m_treeViewer.setInput(root);
    }

    private static class AggregatingViewerFilter
    extends ViewerFilter {
        private final List<ViewerFilter> m_filters;
        private int m_hidden;

        public AggregatingViewerFilter(List<ViewerFilter> filters) {
            assert (filters != null) : "Parameter 'filters' of method 'AggregatingViewerFilter' must not be null";
            this.m_filters = filters;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            for (ViewerFilter filter : this.m_filters) {
                if (filter.select(viewer, parentElement, element)) continue;
                ++this.m_hidden;
                return false;
            }
            return true;
        }

        public boolean hasHiddenElements() {
            return this.m_hidden > 0;
        }

        public List<ViewerFilter> getFilters() {
            return Collections.unmodifiableList(this.m_filters);
        }
    }
}

