/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class DrawableWidgetSelection {
    private final Set<RepresentationElement> m_fullElementSelection = new LinkedHashSet<RepresentationElement>();
    private final Set<RepresentationNode> m_representationNodeSelection = new LinkedHashSet<RepresentationNode>();
    private final Set<RepresentationDependency> m_representationEdgeSelection = new LinkedHashSet<RepresentationDependency>();
    private final Set<IDrawableNode> m_drawableNodeSelection = new LinkedHashSet<IDrawableNode>();
    private final Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> m_drawableEdgeSelection = new LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>>();

    public void addToSelection(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToSelection' must not be null";
        if (figure instanceof IDrawableNode) {
            IDrawableNode node = (IDrawableNode)figure;
            this.m_drawableNodeSelection.add(node);
            this.m_representationNodeSelection.add((RepresentationNode)node.getRepresentationElement());
            this.m_fullElementSelection.add((RepresentationElement)node.getRepresentationElement());
        }
        if (figure instanceof IDrawableNode.IDrawableEdge) {
            IDrawableNode.IDrawableEdge edge = (IDrawableNode.IDrawableEdge)figure;
            this.m_drawableEdgeSelection.add(edge);
            this.m_representationEdgeSelection.add((RepresentationDependency)edge.getRepresentationElement());
            this.m_fullElementSelection.add((RepresentationElement)edge.getRepresentationElement());
        }
    }

    public void removeFromSelection(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromSelection' must not be null";
        if (figure instanceof IDrawableNode) {
            IDrawableNode node = (IDrawableNode)figure;
            this.m_drawableNodeSelection.remove(node);
            this.m_representationNodeSelection.remove(node.getRepresentationElement());
            this.m_fullElementSelection.remove(node.getRepresentationElement());
        }
        if (figure instanceof IDrawableNode.IDrawableEdge) {
            IDrawableNode.IDrawableEdge edge = (IDrawableNode.IDrawableEdge)figure;
            this.m_drawableEdgeSelection.remove(edge);
            this.m_representationEdgeSelection.remove(edge.getRepresentationElement());
            this.m_fullElementSelection.remove(edge.getRepresentationElement());
        }
    }

    public void clear() {
        this.m_fullElementSelection.clear();
        this.m_drawableNodeSelection.clear();
        this.m_representationNodeSelection.clear();
        this.m_representationEdgeSelection.clear();
        this.m_drawableEdgeSelection.clear();
    }

    public Set<RepresentationElement> getFullElementSelection() {
        return Collections.unmodifiableSet(this.m_fullElementSelection);
    }

    public Set<RepresentationDependency> getSelectedRepresentationDependencies() {
        return Collections.unmodifiableSet(this.m_representationEdgeSelection);
    }

    public Set<IDrawableNode> getSelectedDrawableNodes() {
        return Collections.unmodifiableSet(this.m_drawableNodeSelection);
    }

    public Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> getSelectedDrawableEdges() {
        return Collections.unmodifiableSet(this.m_drawableEdgeSelection);
    }

    public boolean contains(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'contains' must not be null";
        if (figure instanceof IDrawableNode) {
            return this.m_drawableNodeSelection.contains(figure);
        }
        if (figure instanceof IDrawableNode.IDrawableEdge) {
            return this.m_drawableEdgeSelection.contains(figure);
        }
        return false;
    }
}

