/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.FigureUtilities;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public final class DrawImageAndLabelFigure
extends DrawFigure {
    private Image m_image;
    private String m_text;
    private Dimension m_textSize;

    public DrawImageAndLabelFigure(Image image, String text) {
        this.setFont(UiResourceManager.getInstance().getFont(DrawUtilities.FONT_ID));
        this.update(image, text);
    }

    public boolean update(Image image, String text) {
        assert (image != null) : "Parameter 'image' of method 'setImage' must not be null";
        assert (text != null) : "Parameter 'text' of method 'update' must not be null";
        boolean updated = false;
        if (!image.equals((Object)this.m_image)) {
            this.m_image = image;
            updated = true;
        }
        if (!text.equals(this.m_text)) {
            Dimension overallDimension;
            this.m_text = text;
            if (this.m_text.isEmpty()) {
                this.m_textSize = new Dimension(0, 16);
                overallDimension = new Dimension(16, 16);
            } else {
                this.m_textSize = FigureUtilities.getStringExtents(this.m_text, this.getFont());
                this.m_textSize.width += 3;
                overallDimension = new Dimension(17 + this.m_textSize.width, Math.max(16, this.m_textSize.height) + 1);
            }
            this.minSize = overallDimension;
            this.prefSize = overallDimension;
            this.maxSize = overallDimension;
            updated = true;
        }
        return updated;
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        graphics.setForegroundColor(this.getForegroundColor());
        Font initialFont = graphics.getFont();
        graphics.drawImage(this.m_image, this.bounds.x, this.bounds.y);
        graphics.setFont(this.getFont());
        graphics.drawString(this.m_text, this.bounds.x + 16 + 1, this.bounds.y + (this.bounds.height - this.m_textSize.height) / 2);
        graphics.setFont(initialFont);
    }

    public String toString() {
        return this.m_text == null || this.m_text.isEmpty() ? "<Empty>" : this.m_text;
    }
}

