/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.foundation.utilities.ByteBitFieldUtil;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import org.eclipse.swt.graphics.Color;

public final class DrawExpandCollapseFigure
extends DrawFigure {
    private static final byte EXPANDABLE = 1;
    private static final byte EXPANDED = 2;
    private byte m_flags;
    private byte m_contentStep;

    public DrawExpandCollapseFigure(boolean isExpandable, boolean isExpanded, int contentStep) {
        assert (contentStep >= -1 && contentStep < UiResourceManager.getInstance().getContentSteps()) : "Invalid 'contentStep': " + contentStep;
        this.prefSize = this.maxSize = DrawUtilities.EXPAND_COLLAPSE_FIGURE_DIMENSION;
        this.minSize = this.maxSize;
        this.m_flags = isExpandable ? ByteBitFieldUtil.enableFlag((byte)this.m_flags, (byte)1) : ByteBitFieldUtil.disableFlag((byte)this.m_flags, (byte)1);
        this.m_flags = isExpanded ? ByteBitFieldUtil.enableFlag((byte)this.m_flags, (byte)2) : ByteBitFieldUtil.disableFlag((byte)this.m_flags, (byte)2);
        this.m_contentStep = (byte)contentStep;
    }

    public boolean isExpandable() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_flags, (byte)1);
    }

    public void setIsExpanded(boolean isExpanded) {
        assert (!isExpanded || this.isExpandable()) : "Not expandable";
        this.m_flags = isExpanded ? ByteBitFieldUtil.enableFlag((byte)this.m_flags, (byte)2) : ByteBitFieldUtil.disableFlag((byte)this.m_flags, (byte)2);
    }

    public boolean isExpanded() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_flags, (byte)2);
    }

    public boolean toggleIsExpanded() {
        this.setIsExpanded(!this.isExpanded());
        return this.isExpanded();
    }

    public void setContentStep(int contentStep) {
        assert (contentStep >= -1 && contentStep < UiResourceManager.getInstance().getContentSteps()) : "Invalid 'contentStep': " + contentStep;
        this.m_contentStep = (byte)contentStep;
    }

    public byte getContentStep() {
        return this.m_contentStep;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialBackgroundColor = graphics.getBackgroundColor();
        Color initialColor = graphics.getForegroundColor();
        int initialLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.VERY_DARK_GREY));
        if (this.isExpandable()) {
            graphics.setBackgroundColor(UiResourceManager.getInstance().getContentColor(this.m_contentStep));
            Rectangle rectangle = Rectangle.SINGLETON;
            rectangle.setBounds(this.getBounds()).resize(-3, -3).translate(2, 2);
            graphics.fillRectangle(rectangle);
            rectangle.setBounds(this.getBounds()).resize(-4, -4).translate(2, 2);
            graphics.drawRectangle(rectangle);
            int xMid = rectangle.x + rectangle.width / 2;
            int yMid = rectangle.y + rectangle.height / 2;
            graphics.drawLine(rectangle.x + 2, yMid, rectangle.right() - 2, yMid);
            if (!this.isExpanded()) {
                graphics.drawLine(xMid, rectangle.y + 2, xMid, rectangle.bottom() - 2);
            }
        }
        graphics.setBackgroundColor(initialBackgroundColor);
        graphics.setLineWidth(initialLineWidth);
        graphics.setForegroundColor(initialColor);
    }
}

