/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.compositecommand;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import java.util.List;

public abstract class CompositeCommandAdapter {
    public abstract Type getType();

    public abstract ICommandId getCorrespondingCommandId();

    public abstract Applicable applicable(ISoftwareSystemProvider var1, List<Element> var2);

    public abstract void apply(ISoftwareSystemProvider var1, List<Element> var2);

    public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> elements) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContectMenu' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'showInContectMenu' must not be null";
        return true;
    }

    public static final class Applicable {
        private static final String THREE_POINTS = "...";
        private final String m_menuLabel;
        private final String m_contextMenuLabel;

        public Applicable() {
            this.m_menuLabel = "";
            this.m_contextMenuLabel = "";
        }

        public Applicable(String menuLabel) {
            assert (menuLabel != null && menuLabel.length() > 0) : "Parameter 'menuLabel' of method 'Applicable' must not be empty";
            this.m_menuLabel = menuLabel;
            this.m_contextMenuLabel = menuLabel;
        }

        public Applicable(String menuLabel, String contextMenuLabel) {
            assert (menuLabel != null && menuLabel.length() > 0) : "Parameter 'menuLabel' of method 'Applicable' must not be empty";
            assert (contextMenuLabel != null && contextMenuLabel.length() > 0) : "Parameter 'contextMenuLabel' of method 'Applicable' must not be empty";
            this.m_menuLabel = menuLabel;
            this.m_contextMenuLabel = contextMenuLabel;
        }

        public String getMenuLabel(Type type, boolean opensDialog) {
            assert (type != null) : "Parameter 'type' of method 'getMenuLabel' must not be null";
            return type.getPresentationName() + (this.m_menuLabel.isEmpty() ? "" : " ") + this.m_menuLabel + (opensDialog ? THREE_POINTS : "");
        }

        public String getContextMenuLabel(Type type, boolean opensDialog) {
            assert (type != null) : "Parameter 'type' of method 'getContextMenuLabel' must not be null";
            return type.getPresentationName() + (this.m_contextMenuLabel.isEmpty() ? "" : " ") + this.m_contextMenuLabel + (opensDialog ? THREE_POINTS : "");
        }

        public String toString() {
            return this.m_menuLabel + "/" + this.m_contextMenuLabel;
        }
    }

    public static enum Type implements IStandardEnumeration
    {
        EDIT,
        DELETE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

