/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractHorizontalSeparator
extends Composite
implements ControlListener,
PaintListener {
    private final String m_text;
    private final Label m_imageLabel;
    private final GridData m_textLayout;
    private final Label m_textLabel;
    private final int m_initialTextWidth;
    private boolean m_initialized;
    private Pair<String, Image> m_initializeWidth;
    private ILayoutListener m_layoutListener;
    private final Label m_separatorLeft;
    private final Label m_separatorRight;

    protected AbstractHorizontalSeparator(Composite parent, String text, Color textColor, Color textBackgroundColor, String tooltipText) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'HorizontalSeparator' must not be null";
        assert (textColor != null) : "Parameter 'textColor' of method 'AbstractHorizontalSeparator' must not be null";
        assert (textBackgroundColor != null) : "Parameter 'textBackgroundColor' of method 'AbstractHorizontalSeparator' must not be null";
        this.m_text = text;
        GridLayout gridLayout = this.m_text != null ? new GridLayout(4, false) : new GridLayout(3, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.m_separatorLeft = new Label((Composite)this, 258);
        this.m_separatorLeft.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_separatorLeft.setBackground(UiResourceManager.getInstance().getSeparatorColor());
        this.m_imageLabel = new Label((Composite)this, 0);
        this.m_imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        if (text != null) {
            this.m_textLabel = new Label((Composite)this, 64);
            this.m_textLabel.setText(this.m_text);
            this.m_initialTextWidth = this.m_textLabel.computeSize((int)-1, (int)-1).x;
            this.m_textLayout = new GridData(0x1000000, 0x1000000, false, false);
            this.m_textLabel.setLayoutData((Object)this.m_textLayout);
            this.m_textLabel.setForeground(textColor);
            this.m_textLabel.setBackground(textBackgroundColor);
        } else {
            this.m_textLabel = null;
            this.m_initialTextWidth = 0;
            this.m_textLayout = null;
        }
        this.m_separatorRight = new Label((Composite)this, 258);
        this.m_separatorRight.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_separatorRight.setBackground(UiResourceManager.getInstance().getSeparatorColor());
        this.addPaintListener(this);
        this.addControlListener(this);
        this.setTooltipForControls(tooltipText);
    }

    protected AbstractHorizontalSeparator(Composite parent, String text, Color textColor) {
        this(parent, text, textColor, UiResourceManager.getInstance().getBackgroundColor(), null);
    }

    public void setLayoutListener(ILayoutListener layoutListener) {
        this.m_layoutListener = layoutListener;
    }

    protected List<Control> getControls() {
        if (this.m_textLabel != null) {
            return Arrays.asList(this.m_separatorLeft, this.m_imageLabel, this.m_textLabel, this.m_separatorRight);
        }
        return Arrays.asList(this.m_separatorLeft, this.m_imageLabel, this.m_separatorRight);
    }

    private boolean hasBeenInitialized() {
        if (!this.m_initialized) {
            Rectangle bounds = this.getBounds();
            this.m_initialized = bounds != null && bounds.width > 0;
        }
        return this.m_initialized;
    }

    private void adaptLayout() {
        if (this.hasBeenInitialized() && this.m_initializeWidth == null) {
            if (this.m_textLayout != null) {
                Rectangle bounds = this.getBounds();
                int availableWidth = bounds.width - 10;
                int widthToUse = availableWidth <= 0 ? this.m_initialTextWidth : Math.max(availableWidth, this.m_initialTextWidth);
                int preferredWidth = this.m_textLabel.computeSize((int)-1, (int)-1).x;
                this.m_textLayout.widthHint = preferredWidth > widthToUse ? widthToUse : preferredWidth;
            }
            this.layout(true, true);
            if (this.m_layoutListener != null) {
                this.m_layoutListener.layoutAdapted();
            }
        }
    }

    private void initializeIfNecessary() {
        if (this.hasBeenInitialized() && this.m_initializeWidth != null) {
            this.set((String)this.m_initializeWidth.getFirst(), (Image)this.m_initializeWidth.getSecond(), this.getToolTipText());
            this.m_initializeWidth = null;
        }
    }

    public final void set(String text, Image image) {
        this.set(text, image, this.getToolTipText());
    }

    public final void set(String text, Image image, String tooltipText) {
        this.setTooltipForControls(tooltipText);
        if (!this.hasBeenInitialized()) {
            this.m_initializeWidth = new Pair((Object)text, (Object)image);
        } else {
            boolean modified = false;
            if (text != null && !text.equals(this.m_textLabel.getText())) {
                this.m_textLabel.setText(text);
                modified = true;
            }
            if (image != this.m_imageLabel.getImage()) {
                this.m_imageLabel.setImage(image);
                modified = true;
            }
            if (modified) {
                this.adaptLayout();
            }
        }
    }

    private void setTooltipForControls(String tooltipText) {
        this.setToolTipText(tooltipText);
        this.getControls().forEach(c -> c.setToolTipText(tooltipText));
    }

    public void reset() {
        this.set(this.m_text, null, null);
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        this.initializeIfNecessary();
        this.adaptLayout();
    }

    public void paintControl(PaintEvent event) {
        this.initializeIfNecessary();
        this.removePaintListener(this);
    }

    public static interface ILayoutListener {
        public void layoutAdapted();
    }
}

