/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.GraphVisitor;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Node;
import com.hello2morrow.draw2d.Rank;

class VerticalPlacement
extends GraphVisitor {
    VerticalPlacement() {
    }

    @Override
    void visit(DirectedGraph g) {
        int currentY = g.getMargin().top;
        g.rankLocations = new int[g.ranks.size() + 1];
        int row = 0;
        while (row < g.ranks.size()) {
            g.rankLocations[row] = currentY;
            Rank rank = g.ranks.getRank(row);
            int rowHeight = 0;
            rank.bottomPadding = 0;
            rank.topPadding = 0;
            int n = 0;
            while (n < rank.size()) {
                Node node = rank.getNode(n);
                Insets pad = g.getPadding(node);
                rowHeight = Math.max(node.height, rowHeight);
                rank.topPadding = Math.max(pad.top, rank.topPadding);
                rank.bottomPadding = Math.max(pad.bottom, rank.bottomPadding);
                ++n;
            }
            rank.setDimensions(currentY += rank.topPadding, rowHeight);
            currentY += rank.height + rank.bottomPadding;
            ++row;
        }
        g.rankLocations[row] = currentY;
        g.size.height = currentY;
    }
}

