/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Obstacle;
import com.hello2morrow.draw2d.Path;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.Segment;
import com.hello2morrow.draw2d.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShortestPathRouter {
    private static final int NUM_GROW_PASSES = 2;
    private int spacing = 4;
    private boolean growPassChangedObstacles;
    private List orderedPaths;
    private Map pathsToChildPaths;
    private PathStack stack;
    private List subPaths;
    private List userObstacles;
    private List userPaths = new ArrayList();
    private List workingPaths = new ArrayList();

    public ShortestPathRouter() {
        this.pathsToChildPaths = new HashMap();
        this.userObstacles = new ArrayList();
    }

    public boolean addObstacle(Rectangle rect) {
        return this.internalAddObstacle(new Obstacle(rect, this));
    }

    public void addPath(Path path) {
        this.userPaths.add(path);
        this.workingPaths.add(path);
    }

    private void bendPaths() {
        int i = 0;
        while (i < this.orderedPaths.size()) {
            Path path = (Path)this.orderedPaths.get(i);
            Segment segment = null;
            path.points.addPoint(new Point(path.start.x, path.start.y));
            int v = 0;
            while (v < path.grownSegments.size()) {
                segment = (Segment)path.grownSegments.get(v);
                Vertex vertex = segment.end;
                if (vertex != null && v < path.grownSegments.size() - 1) {
                    if (vertex.type == 1) {
                        ++vertex.count;
                        path.points.addPoint(vertex.bend(vertex.count));
                    } else {
                        path.points.addPoint(vertex.bend(vertex.totalCount));
                        --vertex.totalCount;
                    }
                }
                ++v;
            }
            path.points.addPoint(new Point(path.end.x, path.end.y));
            ++i;
        }
    }

    private void checkVertexForIntersections(Vertex vertex) {
        if (vertex.nearestObstacle != 0 || vertex.nearestObstacleChecked) {
            return;
        }
        int sideLength = 2 * (vertex.totalCount * this.getSpacing()) + 1;
        int y = (vertex.positionOnObstacle & 1) > 0 ? vertex.y - sideLength : vertex.y;
        int x = (vertex.positionOnObstacle & 0x10) > 0 ? vertex.x : vertex.x - sideLength;
        Rectangle r = new Rectangle(x, y, sideLength, sideLength);
        int o = 0;
        while (o < this.userObstacles.size()) {
            int yDist;
            int xDist;
            int pos;
            Obstacle obs = (Obstacle)this.userObstacles.get(o);
            if (obs != vertex.obs && r.intersects(obs) && (pos = obs.getPosition(vertex)) != 0 && (Math.max(xDist = (pos & 0x10) > 0 ? vertex.x - obs.right() + 1 : obs.x - vertex.x, yDist = (pos & 1) > 0 ? obs.y - vertex.y : vertex.y - obs.bottom() + 1) < vertex.nearestObstacle || vertex.nearestObstacle == 0)) {
                vertex.nearestObstacle = Math.max(xDist, yDist);
                vertex.updateOffset();
            }
            ++o;
        }
        vertex.nearestObstacleChecked = true;
    }

    private void checkVertexIntersections() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            int s = 0;
            while (s < path.segments.size() - 1) {
                Vertex vertex = ((Segment)path.segments.get((int)s)).end;
                this.checkVertexForIntersections(vertex);
                ++s;
            }
            ++i;
        }
    }

    private void cleanup() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            path.cleanup();
            ++i;
        }
    }

    private void countVertices() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            int v = 0;
            while (v < path.segments.size() - 1) {
                ++((Segment)path.segments.get((int)v)).end.totalCount;
                ++v;
            }
            ++i;
        }
    }

    private boolean dirtyPathsOn(Vertex vertex) {
        List paths = vertex.paths;
        if (paths != null && paths.size() != 0) {
            int i = 0;
            while (i < paths.size()) {
                ((Path)paths.get((int)i)).isDirty = true;
                ++i;
            }
            return true;
        }
        return false;
    }

    private Vertex getNearestVertex(Vertex v1, Vertex v2, Segment segment) {
        if (segment.start.getDistance(v1) + segment.end.getDistance(v1) > segment.start.getDistance(v2) + segment.end.getDistance(v2)) {
            return v2;
        }
        return v1;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private Path getSubpathForSplit(Path path, Segment segment) {
        Path newPath = path.getSubPath(segment);
        this.workingPaths.add(newPath);
        this.subPaths.add(newPath);
        return newPath;
    }

    private void growObstacles() {
        this.growPassChangedObstacles = false;
        int i = 0;
        while (i < 2) {
            if (i == 0 || this.growPassChangedObstacles) {
                this.growObstaclesPass();
            }
            ++i;
        }
    }

    private void growObstaclesPass() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            ((Obstacle)this.userObstacles.get(i)).growVertices();
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            int e = 0;
            while (e < path.excludedObstacles.size()) {
                ((Obstacle)path.excludedObstacles.get((int)e)).exclude = true;
                ++e;
            }
            if (path.grownSegments.size() == 0) {
                int s = 0;
                while (s < path.segments.size()) {
                    this.testOffsetSegmentForIntersections((Segment)path.segments.get(s), -1, path);
                    ++s;
                }
            } else {
                int counter = 0;
                ArrayList currentSegments = new ArrayList(path.grownSegments);
                int s = 0;
                while (s < currentSegments.size()) {
                    counter += this.testOffsetSegmentForIntersections((Segment)currentSegments.get(s), s + counter, path);
                    ++s;
                }
            }
            e = 0;
            while (e < path.excludedObstacles.size()) {
                ((Obstacle)path.excludedObstacles.get((int)e)).exclude = false;
                ++e;
            }
            ++i;
        }
        i = 0;
        while (i < this.userObstacles.size()) {
            ((Obstacle)this.userObstacles.get(i)).shrinkVertices();
            ++i;
        }
    }

    private boolean internalAddObstacle(Obstacle obs) {
        this.userObstacles.add(obs);
        return this.testAndDirtyPaths(obs);
    }

    private boolean internalRemoveObstacle(Rectangle rect) {
        Obstacle obs = null;
        int index = -1;
        int i = 0;
        while (i < this.userObstacles.size()) {
            obs = (Obstacle)this.userObstacles.get(i);
            if (obs.equals(rect)) {
                index = i;
                break;
            }
            ++i;
        }
        this.userObstacles.remove(index);
        boolean result = false;
        result |= this.dirtyPathsOn(obs.bottomLeft);
        result |= this.dirtyPathsOn(obs.topLeft);
        result |= this.dirtyPathsOn(obs.bottomRight);
        result |= this.dirtyPathsOn(obs.topRight);
        int p = 0;
        while (p < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(p);
            if (!path.isDirty && path.isObstacleVisible(obs)) {
                result = true;
                path.isDirty = true;
            }
            ++p;
        }
        return result;
    }

    private void labelPath(Path path) {
        Segment segment = null;
        Segment nextSegment = null;
        Vertex vertex = null;
        boolean agree = false;
        int v = 0;
        while (v < path.grownSegments.size() - 1) {
            segment = (Segment)path.grownSegments.get(v);
            nextSegment = (Segment)path.grownSegments.get(v + 1);
            vertex = segment.end;
            long crossProduct = segment.crossProduct(new Segment(vertex, vertex.obs.center));
            if (vertex.type == 0) {
                this.labelVertex(segment, crossProduct, path);
            } else if (!path.isInverted && (crossProduct > 0L && vertex.type == 2 || crossProduct < 0L && vertex.type == 1)) {
                if (agree) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                path.isInverted = true;
                path.invertPriorVertices(segment);
            } else {
                if (path.isInverted && (crossProduct < 0L && vertex.type == 2 || crossProduct > 0L && vertex.type == 1)) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                agree = true;
            }
            if (vertex.paths != null) {
                int i = 0;
                while (i < vertex.paths.size()) {
                    Path nextPath = (Path)vertex.paths.get(i);
                    if (!nextPath.isMarked) {
                        nextPath.isMarked = true;
                        this.stack.push(nextPath);
                    }
                    ++i;
                }
            }
            vertex.addPath(path, segment, nextSegment);
            ++v;
        }
    }

    private void labelPaths() {
        Path path = null;
        int i = 0;
        while (i < this.workingPaths.size()) {
            path = (Path)this.workingPaths.get(i);
            this.stack.push(path);
            ++i;
        }
        while (!this.stack.isEmpty()) {
            path = this.stack.pop();
            if (path.isMarked) continue;
            path.isMarked = true;
            this.labelPath(path);
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            path = (Path)this.workingPaths.get(i);
            path.isMarked = false;
            ++i;
        }
    }

    private void labelVertex(Segment segment, long crossProduct, Path path) {
        segment.end.type = crossProduct > 0L ? (path.isInverted ? 2 : 1) : (crossProduct < 0L ? (path.isInverted ? 1 : 2) : (segment.start.type != 0 ? segment.start.type : 1));
    }

    private void orderPath(Path path) {
        if (path.isMarked) {
            return;
        }
        path.isMarked = true;
        Segment segment = null;
        Vertex vertex = null;
        int v = 0;
        while (v < path.grownSegments.size() - 1) {
            segment = (Segment)path.grownSegments.get(v);
            vertex = segment.end;
            double thisAngle = (Double)vertex.cachedCosines.get(path);
            if (path.isInverted) {
                thisAngle = -thisAngle;
            }
            int i = 0;
            while (i < vertex.paths.size()) {
                Path vPath = (Path)vertex.paths.get(i);
                if (!vPath.isMarked) {
                    double otherAngle = (Double)vertex.cachedCosines.get(vPath);
                    if (vPath.isInverted) {
                        otherAngle = -otherAngle;
                    }
                    if (otherAngle < thisAngle) {
                        this.orderPath(vPath);
                    }
                }
                ++i;
            }
            ++v;
        }
        this.orderedPaths.add(path);
    }

    private void orderPaths() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            this.orderPath(path);
            ++i;
        }
    }

    private void recombineChildrenPaths() {
        for (Path path : this.pathsToChildPaths.keySet()) {
            path.fullReset();
            List childPaths = (List)this.pathsToChildPaths.get(path);
            Path childPath = null;
            int i = 0;
            while (i < childPaths.size()) {
                childPath = (Path)childPaths.get(i);
                path.points.addAll(childPath.getPoints());
                path.points.removePoint(path.points.size() - 1);
                path.segments.addAll(childPath.segments);
                path.visibleObstacles.addAll(childPath.visibleObstacles);
                ++i;
            }
            path.points.addPoint(childPath.points.getLastPoint());
        }
    }

    private void recombineSubpaths() {
        int p = 0;
        while (p < this.orderedPaths.size()) {
            Path path = (Path)this.orderedPaths.get(p);
            path.reconnectSubPaths();
            ++p;
        }
        this.orderedPaths.removeAll(this.subPaths);
        this.workingPaths.removeAll(this.subPaths);
        this.subPaths = null;
    }

    public boolean removeObstacle(Rectangle rect) {
        return this.internalRemoveObstacle(rect);
    }

    public boolean removePath(Path path) {
        this.userPaths.remove(path);
        List children = (List)this.pathsToChildPaths.get(path);
        if (children == null) {
            this.workingPaths.remove(path);
        } else {
            this.workingPaths.removeAll(children);
        }
        return true;
    }

    private void resetObstacleExclusions() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            ((Obstacle)this.userObstacles.get((int)i)).exclude = false;
            ++i;
        }
    }

    private void resetVertices() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            Obstacle obs = (Obstacle)this.userObstacles.get(i);
            obs.reset();
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            path.start.fullReset();
            path.end.fullReset();
            ++i;
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public List solve() {
        this.solveDirtyPaths();
        this.countVertices();
        this.checkVertexIntersections();
        this.growObstacles();
        this.subPaths = new ArrayList();
        this.stack = new PathStack();
        this.labelPaths();
        this.stack = null;
        this.orderedPaths = new ArrayList();
        this.orderPaths();
        this.bendPaths();
        this.recombineSubpaths();
        this.orderedPaths = null;
        this.subPaths = null;
        this.recombineChildrenPaths();
        this.cleanup();
        return Collections.unmodifiableList(this.userPaths);
    }

    private int solveDirtyPaths() {
        Path path;
        int numSolved = 0;
        int i = 0;
        while (i < this.userPaths.size()) {
            path = (Path)this.userPaths.get(i);
            if (path.isDirty) {
                List children = (List)this.pathsToChildPaths.get(path);
                int prevCount = 1;
                int newCount = 1;
                if (children == null) {
                    children = Collections.EMPTY_LIST;
                } else {
                    prevCount = children.size();
                }
                if (path.getBendPoints() != null) {
                    newCount = path.getBendPoints().size() + 1;
                }
                if (prevCount != newCount) {
                    children = this.regenerateChildPaths(path, children, prevCount, newCount);
                }
                this.refreshChildrenEndpoints(path, children);
            }
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            path = (Path)this.workingPaths.get(i);
            path.refreshExcludedObstacles(this.userObstacles);
            if (!path.isDirty) {
                path.resetPartial();
            } else {
                ++numSolved;
                path.fullReset();
                boolean pathFoundCheck = path.generateShortestPath(this.userObstacles);
                if (!pathFoundCheck || path.end.cost > path.threshold) {
                    this.resetVertices();
                    path.fullReset();
                    path.threshold = 0.0;
                    pathFoundCheck = path.generateShortestPath(this.userObstacles);
                }
                this.resetVertices();
            }
            ++i;
        }
        this.resetObstacleExclusions();
        if (numSolved == 0) {
            this.resetVertices();
        }
        return numSolved;
    }

    private void refreshChildrenEndpoints(Path path, List children) {
        Point previous = path.getStartPoint();
        PointList bendpoints = path.getBendPoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendpoints.size() ? bendpoints.getPoint(i) : path.getEndPoint();
            Path child = (Path)children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List regenerateChildPaths(Path path, List children, int currentSize, int newSize) {
        block2: {
            if (currentSize != 1) break block2;
            this.workingPaths.remove(path);
            currentSize = 0;
            children = new ArrayList<Path>(newSize);
            this.pathsToChildPaths.put(path, children);
            ** GOTO lbl24
        }
        if (newSize != 1) ** GOTO lbl24
        this.workingPaths.removeAll(children);
        this.workingPaths.add(path);
        this.pathsToChildPaths.remove(path);
        return Collections.EMPTY_LIST;
lbl-1000:
        // 1 sources

        {
            child = new Path();
            this.workingPaths.add(child);
            children.add(child);
            ++currentSize;
lbl24:
            // 3 sources

            ** while (currentSize < newSize)
        }
lbl25:
        // 2 sources

        while (currentSize > newSize) {
            child = (Path)children.remove(children.size() - 1);
            this.workingPaths.remove(child);
            --currentSize;
        }
        return children;
    }

    private int testOffsetSegmentForIntersections(Segment segment, int index, Path path) {
        int i = 0;
        while (i < this.userObstacles.size()) {
            Obstacle obs = (Obstacle)this.userObstacles.get(i);
            if (segment.end.obs != obs && segment.start.obs != obs && !obs.exclude) {
                Vertex vertex = null;
                int offset = this.getSpacing();
                if (segment.getSlope() < 0.0) {
                    if (segment.intersects(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset)) {
                        vertex = this.getNearestVertex(obs.topLeft, obs.bottomRight, segment);
                    } else if (segment.intersects(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset)) {
                        vertex = this.getNearestVertex(obs.bottomLeft, obs.topRight, segment);
                    }
                } else if (segment.intersects(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset)) {
                    vertex = this.getNearestVertex(obs.bottomLeft, obs.topRight, segment);
                } else if (segment.intersects(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset)) {
                    vertex = this.getNearestVertex(obs.topLeft, obs.bottomRight, segment);
                }
                if (vertex != null) {
                    Rectangle startRect;
                    Rectangle endRect;
                    Rectangle vRect = vertex.getDeformedRectangle(offset);
                    if (!(segment.end.obs != null && vRect.intersects(endRect = segment.end.getDeformedRectangle(offset)) || segment.start.obs != null && vRect.intersects(startRect = segment.start.getDeformedRectangle(offset)))) {
                        Segment newSegmentStart = new Segment(segment.start, vertex);
                        Segment newSegmentEnd = new Segment(vertex, segment.end);
                        ++vertex.totalCount;
                        vertex.nearestObstacleChecked = false;
                        vertex.shrink();
                        this.checkVertexForIntersections(vertex);
                        vertex.grow();
                        if (vertex.nearestObstacle != 0) {
                            vertex.updateOffset();
                        }
                        this.growPassChangedObstacles = true;
                        if (index != -1) {
                            path.grownSegments.remove(segment);
                            path.grownSegments.add(index, newSegmentStart);
                            path.grownSegments.add(index + 1, newSegmentEnd);
                        } else {
                            path.grownSegments.add(newSegmentStart);
                            path.grownSegments.add(newSegmentEnd);
                        }
                        return 1;
                    }
                }
            }
            ++i;
        }
        if (index == -1) {
            path.grownSegments.add(segment);
        }
        return 0;
    }

    private boolean testAndDirtyPaths(Obstacle obs) {
        boolean result = false;
        int i = 0;
        while (i < this.workingPaths.size()) {
            Path path = (Path)this.workingPaths.get(i);
            result |= path.testAndSet(obs);
            ++i;
        }
        return result;
    }

    public boolean updateObstacle(Rectangle oldBounds, Rectangle newBounds) {
        boolean result = this.internalRemoveObstacle(oldBounds);
        return result |= this.addObstacle(newBounds);
    }

    static class PathStack
    extends ArrayList {
        PathStack() {
        }

        Path pop() {
            return (Path)this.remove(this.size() - 1);
        }

        void push(Path path) {
            this.add(path);
        }
    }
}

