/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractPointListShape;
import com.hello2morrow.draw2d.Geometry;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;

public class PolylineShape
extends AbstractPointListShape {
    private int tolerance = 2;

    @Override
    protected boolean shapeContainsPoint(int x, int y) {
        Point location = this.getLocation();
        return Geometry.polylineContainsPoint(this.points, x - location.x, y - location.y, this.tolerance);
    }

    @Override
    protected void fillShape(Graphics graphics) {
    }

    @Override
    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        graphics.translate(this.getLocation());
        graphics.drawPolyline(this.points);
        graphics.popState();
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }
}

