/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.GraphVisitor;
import com.hello2morrow.draw2d.Rank;
import com.hello2morrow.draw2d.RankSorter;

class MinCross
extends GraphVisitor {
    static final int MAX = 45;
    private DirectedGraph g;
    private RankSorter sorter = new RankSorter();

    public MinCross() {
    }

    public MinCross(RankSorter sorter) {
        this.setRankSorter(sorter);
    }

    public void setRankSorter(RankSorter sorter) {
        this.sorter = sorter;
    }

    void solve() {
        int loop = 0;
        while (loop < 45) {
            Rank rank;
            int row = 1;
            while (row < this.g.ranks.size()) {
                rank = this.g.ranks.getRank(row);
                this.sorter.sortRankIncoming(this.g, rank, row, (double)loop / 45.0);
                ++row;
            }
            if (loop != 44) {
                row = this.g.ranks.size() - 2;
                while (row >= 0) {
                    rank = this.g.ranks.getRank(row);
                    this.sorter.sortRankOutgoing(this.g, rank, row, (double)loop / 45.0);
                    --row;
                }
            }
            ++loop;
        }
    }

    @Override
    public void visit(DirectedGraph g) {
        this.sorter.init(g);
        this.g = g;
        this.solve();
        this.sorter.optimize(g);
    }
}

