/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.ColorConstants;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PositionConstants;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.TextUtilities;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class Label
extends Figure
implements PositionConstants {
    private static String ELLIPSIS = "...";
    private Image icon;
    private String text = "";
    private String subStringText;
    private Dimension textSize;
    private Dimension subStringTextSize;
    private Dimension iconSize = new Dimension(0, 0);
    private Point iconLocation;
    private Point textLocation;
    private int textAlignment = 2;
    private int iconAlignment = 2;
    private int labelAlignment = 2;
    private int textPlacement = 16;
    private int iconTextGap = 3;

    public Label() {
    }

    public Label(String s) {
        this.setText(s);
    }

    public Label(Image i) {
        this.setIcon(i);
    }

    public Label(String s, Image i) {
        this.setText(s);
        this.setIcon(i);
    }

    private void alignOnHeight(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 8: {
                loc.y = insets.top;
                break;
            }
            case 32: {
                loc.y = this.bounds.height - size.height - insets.bottom;
                break;
            }
            default: {
                loc.y = (this.bounds.height - size.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 1: {
                loc.x = insets.left;
                break;
            }
            case 4: {
                loc.x = this.bounds.width - size.width - insets.right;
                break;
            }
            default: {
                loc.x = (this.bounds.width - size.width) / 2;
            }
        }
    }

    private void calculateAlignment() {
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getTextSize(), this.textAlignment);
                this.alignOnHeight(this.iconLocation, this.getIconSize(), this.iconAlignment);
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.textAlignment);
                this.alignOnWidth(this.iconLocation, this.getIconSize(), this.iconAlignment);
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.getIconTextGap();
        if (this.getIcon() == null || this.getText().equals("")) {
            gap = 0;
        }
        Dimension d = new Dimension(0, 0);
        if (this.textPlacement == 8 || this.textPlacement == 16) {
            d.width = this.getIconSize().width + gap + txtSize.width;
            d.height = Math.max(this.getIconSize().height, txtSize.height);
        } else {
            d.width = Math.max(this.getIconSize().width, txtSize.width);
            d.height = this.getIconSize().height + gap + txtSize.height;
        }
        return d;
    }

    private void calculateLocations() {
        this.textLocation = new Point();
        this.iconLocation = new Point();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension offset = this.getSize().getDifference(this.getPreferredSize());
        offset.width += this.getTextSize().width - this.getSubStringTextSize().width;
        switch (this.labelAlignment) {
            case 2: {
                offset.scale(0.5);
                break;
            }
            case 1: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                offset.height = 0;
                break;
            }
            case 1: 
            case 4: {
                offset.width = 0;
            }
        }
        this.textLocation.translate(offset);
        this.iconLocation.translate(offset);
    }

    private void calculatePlacement() {
        int gap = this.getIconTextGap();
        if (this.icon == null || this.text.equals("")) {
            gap = 0;
        }
        Insets insets = this.getInsets();
        switch (this.textPlacement) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = this.getIconSize().width + gap + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + gap + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + gap + insets.top;
                break;
            }
            case 4: {
                this.textLocation.y = this.getIconSize().height + gap + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    protected Dimension calculateSubStringTextSize() {
        return this.getTextUtilities().getTextExtents(this.getSubStringText(), this.getFont());
    }

    protected Dimension calculateTextSize() {
        return this.getTextUtilities().getTextExtents(this.getText(), this.getFont());
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public Rectangle getIconBounds() {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.getLocation().translate(this.getIconLocation()), this.getIconSize());
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    @Override
    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize(this, w, h));
        }
        Dimension labelSize = this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getTruncationString(), this.getFont()).intersect(this.getTextUtilities().getTextExtents(this.getText(), this.getFont())));
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            this.prefSize = this.calculateLabelSize(this.getTextSize());
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize(this, wHint, hHint));
            }
        }
        if (wHint >= 0 && wHint < this.prefSize.width) {
            Dimension minSize = this.getMinimumSize(wHint, hHint);
            Dimension result = this.prefSize.getCopy();
            result.width = Math.min(result.width, wHint);
            result.width = Math.max(minSize.width, result.width);
            return result;
        }
        return this.prefSize;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        this.subStringText = this.text;
        int widthShrink = this.getPreferredSize().width - this.getSize().width;
        if (widthShrink <= 0) {
            return this.subStringText;
        }
        Dimension effectiveSize = this.getTextSize().getExpanded(-widthShrink, 0);
        Font currentFont = this.getFont();
        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(this.text, currentFont, effectiveSize.width - dotsWidth);
        this.subStringText = new String(this.text.substring(0, subStringLength) + this.getTruncationString());
        return this.subStringText;
    }

    protected Dimension getSubStringTextSize() {
        if (this.subStringTextSize == null) {
            this.subStringTextSize = this.calculateSubStringTextSize();
        }
        return this.subStringTextSize;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public Rectangle getTextBounds() {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.getLocation().translate(this.getTextLocation()), this.textSize);
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    public int getTextPlacement() {
        return this.textPlacement;
    }

    protected Dimension getTextSize() {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize();
        }
        return this.textSize;
    }

    @Override
    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.textSize = null;
        this.subStringTextSize = null;
        this.subStringText = null;
        super.invalidate();
    }

    public boolean isTextTruncated() {
        return !this.getSubStringText().equals(this.getText());
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }

    public void setIcon(Image image) {
        if (this.icon == image) {
            return;
        }
        this.icon = image;
        this.repaint();
        if (this.icon == null) {
            this.setIconDimension(new Dimension());
        } else {
            this.setIconDimension(new Dimension(image));
        }
    }

    public void setIconAlignment(int align) {
        if (this.iconAlignment == align) {
            return;
        }
        this.iconAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setIconDimension(Dimension d) {
        if (d.equals(this.getIconSize())) {
            return;
        }
        this.iconSize = d;
        this.revalidate();
    }

    public void setIconTextGap(int gap) {
        if (this.iconTextGap == gap) {
            return;
        }
        this.iconTextGap = gap;
        this.repaint();
        this.revalidate();
    }

    public void setLabelAlignment(int align) {
        if (this.labelAlignment == align) {
            return;
        }
        this.labelAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (this.text.equals(s)) {
            return;
        }
        this.text = s;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int align) {
        if (this.textAlignment == align) {
            return;
        }
        this.textAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.textPlacement == where) {
            return;
        }
        this.textPlacement = where;
        this.revalidate();
        this.repaint();
    }

    public TextUtilities getTextUtilities() {
        return TextUtilities.INSTANCE;
    }

    protected String getTruncationString() {
        return ELLIPSIS;
    }

    protected Dimension getIconSize() {
        return this.iconSize;
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }
}

