/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractImageFigure;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ImageFigure
extends AbstractImageFigure {
    private Image img;
    private Dimension size = new Dimension();
    private int alignment;

    public ImageFigure() {
        this(null, 2);
    }

    public ImageFigure(Image image) {
        this(image, 2);
    }

    public ImageFigure(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    @Override
    public Image getImage() {
        return this.img;
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.getInsets() == NO_INSETS) {
            return this.size;
        }
        Insets i = this.getInsets();
        return this.size.getExpanded(i.getWidth(), i.getHeight());
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.getImage() == null) {
            return;
        }
        Rectangle area = this.getBounds().getShrinked(this.getInsets());
        graphics.drawImage(this.getImage(), switch (this.alignment & 0x18) {
            case 16 -> area.x + area.width - this.size.width;
            case 8 -> area.x;
            default -> (area.width - this.size.width) / 2 + area.x;
        }, switch (this.alignment & 5) {
            case 1 -> area.y;
            case 4 -> area.y + area.height - this.size.height;
            default -> (area.height - this.size.height) / 2 + area.y;
        });
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.size = this.img != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        this.revalidate();
        this.notifyImageChanged();
        this.repaint();
    }
}

