/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.FreeformFigure;
import com.hello2morrow.draw2d.FreeformHelper;
import com.hello2morrow.draw2d.FreeformListener;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.draw2d.Rectangle;
import java.util.Iterator;

public class FreeformLayer
extends Layer
implements FreeformFigure {
    private FreeformHelper helper = new FreeformHelper(this);

    @Override
    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        this.helper.hookChild(child);
    }

    @Override
    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    @Override
    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    @Override
    protected void fireMoved() {
    }

    @Override
    public Rectangle getFreeformExtent() {
        return this.helper.getFreeformExtent();
    }

    @Override
    public void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
    }

    @Override
    public void remove(IFigure child) {
        this.helper.unhookChild(child);
        super.remove(child);
    }

    @Override
    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    @Override
    public void setFreeformBounds(Rectangle bounds) {
        this.helper.setFreeformBounds(bounds);
    }
}

