/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractLayout;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Locator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DelegatingLayout
extends AbstractLayout {
    private Map constraints = new HashMap();

    @Override
    protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
        List children = parent.getChildren();
        Dimension d = new Dimension();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getPreferredSize());
            ++i;
        }
        return d;
    }

    @Override
    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    @Override
    public void layout(IFigure parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Locator locator = (Locator)this.constraints.get(child);
            if (locator != null) {
                locator.relocate(child);
            }
            ++i;
        }
    }

    @Override
    public void remove(IFigure child) {
        this.constraints.remove(child);
    }

    @Override
    public void setConstraint(IFigure figure, Object constraint) {
        super.setConstraint(figure, constraint);
        if (constraint != null) {
            this.constraints.put(figure, constraint);
        }
    }
}

