/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Image;

final class RefactoringBeanAdapter
extends BeanPropertyReader.BeanAdapter<RefactoringDefinition> {
    private static final DateFormat DATE_TIME_FORMAT = Iso8601DateFormat.createStandardDateTimeFormat();
    private RefactoringDefinition m_refactoringDefinition;

    RefactoringBeanAdapter() {
    }

    protected void setAdaptedObject(RefactoringDefinition refactoringDefinition) {
        this.m_refactoringDefinition = refactoringDefinition;
    }

    public String getVirtualModel() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getVirtualModel' must not be null";
        VirtualModel virtualModel = (VirtualModel)this.m_refactoringDefinition.getParent(VirtualModel.class, new Class[0]);
        return virtualModel != null ? virtualModel.getName() : null;
    }

    public Image getVirtualModelImage() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getVirtualModelImage' must not be null";
        VirtualModel virtualModel = (VirtualModel)this.m_refactoringDefinition.getParent(VirtualModel.class, new Class[0]);
        return virtualModel != null ? UiResourceManager.getInstance().getImage((Element)virtualModel) : null;
    }

    public final String getProvider() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getDescription' must not be null";
        return this.m_refactoringDefinition.getProvider();
    }

    public final String getDescription() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getDescription' must not be null";
        return this.m_refactoringDefinition.getDescription();
    }

    public String getStatus() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getStatus' must not be null";
        return this.m_refactoringDefinition.getStatus().getPresentationName();
    }

    public final String getDate() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getDate' must not be null";
        return DATE_TIME_FORMAT.format(this.m_refactoringDefinition.getDate());
    }

    public final Date getDateForSort() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getDateForSort' must not be null";
        return this.m_refactoringDefinition.getDate();
    }

    public final String getMatchCount() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getMatchCount' must not be null";
        return String.valueOf(this.m_refactoringDefinition.getMatchingElementsCount());
    }

    public final String getPriority() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getPriority' must not be null";
        return this.m_refactoringDefinition.getPriority().getPresentationName();
    }

    public final int getPriorityForSort() {
        assert (this.m_refactoringDefinition != null) : "Parameter 'm_refactoringDefinition' of method 'getPriorityForSort' must not be null";
        return this.m_refactoringDefinition.getPriority().ordinal();
    }

    public final String getAssignee() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getAssignee' must not be null";
        return this.m_refactoringDefinition.getAssignee();
    }

    public final String getRefactoringType() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getRefactoringType' must not be null";
        return this.m_refactoringDefinition.getPresentationName(true);
    }

    public final Image getRefactoringImage() {
        assert (this.m_refactoringDefinition != null) : "'m_refactoringDefinition' of method 'getRefactoringImage' must not be null";
        return UiResourceManager.getInstance().getImage(this.m_refactoringDefinition.getImageResourceName());
    }

    public final String getInformation() {
        assert (this.m_refactoringDefinition != null) : "'m_resolution' of method 'getIssueType' must not be null";
        return this.m_refactoringDefinition.getInformation();
    }

    public Image getPriorityImage() {
        assert (this.m_refactoringDefinition != null) : "Parameter 'm_refactoringDefinition' of method 'getPriorityImage' must not be null";
        Priority priority = this.m_refactoringDefinition.getPriority();
        switch (priority) {
            case LOW: {
                return UiResourceManager.getInstance().getImage("Low");
            }
            case MEDIUM: {
                return UiResourceManager.getInstance().getImage("Medium");
            }
            case HIGH: {
                return UiResourceManager.getInstance().getImage("High");
            }
            case NONE: {
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        assert (false) : "Unhandled priority: " + String.valueOf(priority);
        return null;
    }
}

