/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class LicenseServerComposite
extends Composite {
    private static final String TEST_CONNECTION = "Test Connection";
    private static final String LICENSE_SERVER_SETTINGS = "com.hello2morrow.sonargraph.ui.swt.licenseServerSettings";
    public static final String TITLE = "License Server Settings";
    private static final String HOST = "HOST";
    private static final String PORT = "PORT";
    private static final String URL = "URL";
    private static final String ACTIVE = "ACTIVE";
    private final IListener m_listener;
    private final ValidatingTextWidget m_url;
    private final Button m_testConnection;
    private final Button m_useLicenseServer;
    private LicenseServerHost m_initialServerSettings;
    private LicenseServerHost m_currentServerSettings;
    private final SonargraphLicenseHandler m_licenseHandler;

    public static LicenseServerHost createLicenseServerSettings(boolean loadNullOrEmptyValues) {
        LicenseServerHost licenseHost = null;
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences(LICENSE_SERVER_SETTINGS);
        String url = eclipsePreferences.get(URL, null);
        boolean active = eclipsePreferences.getBoolean(ACTIVE, false);
        if (url != null && (loadNullOrEmptyValues || url.length() > 0)) {
            return new LicenseServerHost(url, active);
        }
        String host = eclipsePreferences.get(HOST, null);
        if (loadNullOrEmptyValues || host != null && !host.isEmpty()) {
            if (host == null || host.isEmpty()) {
                return new LicenseServerHost(host, active);
            }
            int port = Integer.valueOf(eclipsePreferences.get(PORT, "8080"));
            licenseHost = new LicenseServerHost(String.format("http://%s:%d", host, port), active);
        }
        return licenseHost;
    }

    public LicenseServerComposite(Composite parent, SonargraphLicenseHandler licenseHandler, IListener listener) {
        super(parent, 0);
        assert (listener != null) : "Parameter 'listener' of method 'ProxySettingsComposite' must not be null";
        assert (licenseHandler != null) : "Parameter 'licenseHandler' of method 'LicenseServerComposite' must not be null";
        this.m_initialServerSettings = LicenseServerComposite.createLicenseServerSettings(true);
        this.m_currentServerSettings = this.m_initialServerSettings.copy();
        this.m_licenseHandler = licenseHandler;
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout(2, false));
        Label textLabel = new Label((Composite)this, 131072);
        textLabel.setText("Url: ");
        textLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_url = new ValidatingTextWidget(this, new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                if (!$assertionsDisabled && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
                String error = HttpConnectionCheck.isValidUrl((String)newInput);
                if (error != null) {
                    result.addError(error);
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                LicenseServerComposite.this.m_currentServerSettings.setUrl(input);
                LicenseServerComposite.this.notifyAboutModification();
            }
        });
        this.m_url.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_testConnection = new Button((Composite)this, 8);
        this.m_testConnection.setText(TEST_CONNECTION);
        this.m_testConnection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_testConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseServerComposite.this.m_testConnection.setText("Checking...");
                LicenseServerComposite.this.m_testConnection.setEnabled(false);
                Thread checkingThread = new Thread(() -> {
                    boolean canConnect = SonargraphLicenseHandler.canConnectToLicenseServer((String)LicenseServerComposite.this.m_currentServerSettings.getUrl(), (ProxySettings)LicenseServerComposite.this.m_licenseHandler.getProxySettings());
                    UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                        if (!LicenseServerComposite.this.m_testConnection.isDisposed()) {
                            if (canConnect) {
                                LicenseServerComposite.this.m_testConnection.setText("Test Connection (Success)");
                            } else {
                                LicenseServerComposite.this.m_testConnection.setText("Test Connection (Failure)");
                            }
                            LicenseServerComposite.this.m_testConnection.setEnabled(true);
                        }
                    });
                });
                checkingThread.start();
            }
        });
        this.m_useLicenseServer = new Button((Composite)this, 32);
        this.m_useLicenseServer.setText("Use license server");
        this.m_useLicenseServer.setLayoutData((Object)new GridData(16384, 0, false, false, 2, 1));
        this.m_useLicenseServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseServerComposite.this.m_currentServerSettings.setActive(LicenseServerComposite.this.m_useLicenseServer.getSelection());
                LicenseServerComposite.this.m_listener.inputModified(LicenseServerComposite.this.hasValidData(), !LicenseServerComposite.this.m_initialServerSettings.equals((Object)LicenseServerComposite.this.m_currentServerSettings));
            }
        });
        this.m_listener = listener;
        this.applyCurrentSettingsToWidgets();
    }

    public boolean hasValidData() {
        return HttpConnectionCheck.isValidUrl((String)this.m_currentServerSettings.getUrl()) == null;
    }

    private void notifyAboutModification() {
        boolean hasValidData = this.hasValidData();
        this.m_testConnection.setText(TEST_CONNECTION);
        this.m_testConnection.setEnabled(hasValidData);
        this.m_useLicenseServer.setEnabled(hasValidData);
        this.m_listener.inputModified(hasValidData, !this.m_initialServerSettings.equals((Object)this.m_currentServerSettings));
    }

    private void applyCurrentSettingsToWidgets() {
        this.m_url.setText(this.m_currentServerSettings.getUrl());
        this.m_testConnection.setText(TEST_CONNECTION);
        boolean hasValidData = this.hasValidData();
        this.m_testConnection.setEnabled(hasValidData);
        this.m_useLicenseServer.setSelection(this.m_currentServerSettings.isActive());
        this.m_useLicenseServer.setEnabled(hasValidData);
    }

    public void storeSettings() {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences(LICENSE_SERVER_SETTINGS);
        eclipsePreferences.put(URL, this.m_currentServerSettings.getUrl());
        eclipsePreferences.putBoolean(ACTIVE, this.m_currentServerSettings.isActive());
        PreferencesUtility.save(eclipsePreferences);
        this.m_initialServerSettings = this.m_currentServerSettings.copy();
        this.m_licenseHandler.setLicenseServer(this.m_currentServerSettings);
        this.m_url.setText(this.m_currentServerSettings.getUrl());
    }

    public boolean resetToDefaultsPossible() {
        return !this.m_currentServerSettings.equals((Object)new LicenseServerHost(null, false));
    }

    public void resetToDefaults() {
        this.m_currentServerSettings = new LicenseServerHost(null, false);
        this.applyCurrentSettingsToWidgets();
    }

    public void reset() {
        this.m_currentServerSettings = this.m_initialServerSettings.copy();
        this.applyCurrentSettingsToWidgets();
    }

    public static interface IListener {
        public void inputModified(boolean var1, boolean var2);
    }
}

