/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;

final class GraphViewUtilities {
    private GraphViewUtilities() {
    }

    private static boolean highlight(GraphViewNode.GraphViewDependency dependency, boolean considerParent) {
        assert (dependency != null) : "Parameter 'dependency' of method 'highlight' must not be null";
        if (dependency.isSelected()) {
            return true;
        }
        GraphViewNode fromNode = dependency.getFrom();
        GraphViewNode toNode = dependency.getTo();
        if (considerParent) {
            GraphViewCycleGroupNode cycleGroupNodeFrom = (GraphViewCycleGroupNode)fromNode.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
            GraphViewCycleGroupNode cycleGroupNodeTo = (GraphViewCycleGroupNode)toNode.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
            if (cycleGroupNodeFrom != null && cycleGroupNodeFrom == cycleGroupNodeTo && cycleGroupNodeFrom.isSelected()) {
                return true;
            }
        }
        return fromNode.isSelected() || toNode.isSelected();
    }

    static boolean highlight(GraphViewNode.GraphViewDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'highlight' must not be null";
        return GraphViewUtilities.highlight(dependency, true);
    }

    static boolean highlight(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'highlight' must not be null";
        if (node.isSelected()) {
            return true;
        }
        for (GraphViewNode.GraphViewDependency in : node.getIncomingDependencies()) {
            if (!GraphViewUtilities.highlight(in, false)) continue;
            return true;
        }
        for (GraphViewNode.GraphViewDependency out : node.getOutgoingDependencies()) {
            if (!GraphViewUtilities.highlight(out, false)) continue;
            return true;
        }
        return false;
    }

    static boolean formCycleOfTwo(GraphViewNode node1, GraphViewNode node2) {
        assert (node1 != null) : "Parameter 'node1' of method 'formCycleOfTwo' must not be null";
        assert (node2 != null) : "Parameter 'node2' of method 'formCycleOfTwo' must not be null";
        return node1 != node2 && node1.hasDependencyTo(node2) && node2.hasDependencyTo(node1);
    }

    public static boolean formAtLeastOneCycleOfTwoWithAnotherSelectedNode(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'formAtLeastOneCycleOfTwoWithAnotherSelectedNode' must not be null";
        for (GraphViewNode.GraphViewDependency in : node.getIncomingDependencies()) {
            if (!in.getFrom().isSelected() || !GraphViewUtilities.formCycleOfTwo(node, in.getFrom())) continue;
            return true;
        }
        for (GraphViewNode.GraphViewDependency out : node.getOutgoingDependencies()) {
            if (!out.getTo().isSelected() || !GraphViewUtilities.formCycleOfTwo(node, out.getTo())) continue;
            return true;
        }
        return false;
    }

    public static boolean formCycleOfTwo(GraphViewNode.GraphViewDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'formCycleOfTwo' must not be null";
        return GraphViewUtilities.formCycleOfTwo(dependency.getFrom(), dependency.getTo());
    }

    public static String getPresentationName(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'getPresentationName' must not be null";
        boolean useShortName = !(node.getUnderlyingObject() instanceof IRecursiveElement);
        return node.getPresentationName(useShortName);
    }
}

