/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.ArrowLocator;
import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.PolygonDecoration;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import com.hello2morrow.sonargraph.ui.swt.dependenciesview.LinePropertiesUtilities;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewSourceNodeConnectionFigureAnchor;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewTargetNodeConnectionFigureAnchor;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewUtilities;
import java.util.List;

public final class GraphViewNodeConnectionFigure
extends DrawConnectionFigure<GraphViewNode.GraphViewDependency> {
    private static final double DISTANCE_THRESHOLD = 3.0;

    public GraphViewNodeConnectionFigure(GraphViewNode.GraphViewDependency connection, DrawConnectionFigure.IConnectionFigureProvider<GraphViewNode.GraphViewDependency> provider, GraphViewSourceNodeConnectionFigureAnchor source, GraphViewTargetNodeConnectionFigureAnchor target, ConnectionRouter router) {
        super(connection);
        this.initialize(provider, source, target, router);
        this.add((IFigure)new PolygonDecoration(), new ArrowLocator(this, 3));
        this.updateBounds();
    }

    private void updateBounds() {
        Rectangle rect = new Rectangle(this.getPoints().getBounds());
        rect.expand(3, 3);
        this.bounds = rect;
    }

    @Override
    public void setPoints(PointList pointList) {
        assert (pointList != null) : "Parameter 'pointList' of method 'setPoints' must not be null";
        assert (pointList == this.getPoints()) : "Different instances";
        this.updateBounds();
        this.firePropertyChange("points", null, pointList);
        this.repaint();
    }

    private boolean highlight(GraphViewNode.GraphViewDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'highlight' must not be null";
        if (!this.getProvider().hasSelection()) {
            return true;
        }
        return GraphViewUtilities.highlight(dependency);
    }

    @Override
    protected void performPaintFigure(Graphics graphics, GraphViewNode.GraphViewDependency dependency) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (dependency != null) : "Parameter 'connection' of method 'performPaintFigure' must not be null";
        boolean highlight = this.highlight(dependency);
        List<PolygonDecoration> decorations = DrawUtilities.findChildFigures(PolygonDecoration.class, this);
        if (decorations.size() == 1) {
            PolygonDecoration decoration = decorations.get(0);
            if (highlight) {
                decoration.setBackgroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.BLACK));
            } else {
                decoration.setBackgroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_GREY));
                decoration.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.BLACK));
            }
        }
        LinePropertiesUtilities.setLineAttributes(dependency.getNumberOfParserDependencies(), dependency.getNumberOfParserDependenciesViolating(), dependency.getNumberOfParserDependenciesViolatingToBeFixed(), dependency.getNumberOfParserDependenciesViolatingIgnored(), dependency.getNumberOfParserDependenciesDeprecated(), dependency.getNumberOfParserDependenciesDeprecatedToBeFixed(), dependency.getNumberOfParserDependenciesDeprecatedIgnored(), highlight, graphics);
        graphics.drawPolyline(this.getPoints());
    }

    @Override
    protected boolean performUpdate(GraphViewNode.GraphViewDependency connection) {
        assert (connection != null) : "Parameter 'connection' of method 'performUpdate' must not be null";
        return true;
    }

    @Override
    public boolean containsPoint(int x0, int y0) {
        if (super.containsPoint(x0, y0)) {
            PointList points = this.getPoints();
            assert (points.size() == 2) : "Not a line";
            Point p1 = points.getFirstPoint();
            int x1 = p1.x;
            int y1 = p1.y;
            Point p2 = points.getLastPoint();
            int x2 = p2.x;
            int y2 = p2.y;
            double distance = (double)Math.abs((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            return distance <= 3.0;
        }
        return false;
    }
}

