/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateGraphForPresentationModeChangeCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateGraphRepresentationForHomeRequestedCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateGraphRepresentationForNavigationCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateGraphRepresentationFromSelectionCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationCommand;
import com.hello2morrow.sonargraph.core.command.system.ExtendFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.ExtendGraphFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.FocusGraphRepresentationCommand;
import com.hello2morrow.sonargraph.core.command.system.RemoveFromFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.RemoveFromGraphFocusCommand;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graph.GraphContext;
import com.hello2morrow.sonargraph.core.model.graph.GraphMode;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.CollectionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.AutozoomMode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableViewNavigationStateWrapper;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphWidget;
import com.hello2morrow.sonargraph.ui.swt.graph.LevelizedLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GraphView
extends DrawableSlaveView {
    private static final String HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.highlightInputGraphView";
    private static final String SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyDependenciesOfSelectedNodesGraphView";
    private static final String SHOW_ONLY_VIOLATIONS = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyViolationsGraphView";
    private static final String HIDE_SELF_ARCS = "com.hello2morrow.sonargraph.standalone.handledmenuitem.hideSelfArcsGraphView";
    private static final String SHOW_ONLY_VISIBLE_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledtoolitem.onlyVisible";
    private final List<RepresentationNode> m_currentlySelectedNodes = new ArrayList<RepresentationNode>();
    private GraphWidget m_graphWidget;

    @Override
    public IViewId getViewId() {
        return ViewId.GRAPH_VIEW;
    }

    @Override
    public final List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_graphWidget);
    }

    @Override
    public final IContext getContext() {
        GraphRepresentation graphRepresentation = this.getCurrentGraphRepresentation();
        if (graphRepresentation != null && this.m_graphWidget != null && this.m_graphWidget.showOnlyViolations()) {
            return new GraphContext(super.getContext(), true, graphRepresentation);
        }
        return super.getContext();
    }

    protected GraphWidget createGraphWidget(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createGraphWidget' must not be null";
        return new GraphWidget(viewContentArea, this.getSelectionProviderAdapter(), new LevelizedLayout(), AutozoomMode.NONE);
    }

    @Override
    protected final void createDrawableWidget(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createDrawableWidget' must not be null";
        this.m_graphWidget = this.createGraphWidget(composite);
        this.m_graphWidget.addListeners(this);
    }

    protected final GraphRepresentation getCurrentGraphRepresentation() {
        if (this.m_graphWidget != null) {
            return (GraphRepresentation)this.m_graphWidget.getUnderlyingRepresentation();
        }
        return null;
    }

    protected final void clear() {
        this.m_currentlySelectedNodes.clear();
        if (this.m_graphWidget != null) {
            this.m_graphWidget.clear();
        }
    }

    @Override
    protected void destroyViewContent() {
        super.destroyViewContent();
        if (this.m_graphWidget != null) {
            this.m_graphWidget.removeListeners();
            this.m_graphWidget.dispose();
            this.m_graphWidget = null;
        }
        this.clear();
    }

    protected boolean hideOnSoftwareSystemClosed() {
        return true;
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clear();
        if (this.hideOnSoftwareSystemClosed()) {
            this.hideView();
        }
    }

    protected void consumeRepresentationCommand(CreateRepresentationCommand<GraphRepresentation> command, IWorkbenchView view) {
        if (this.getGraphWidget() != null && !this.getGraphWidget().isDisposed()) {
            this.getGraphWidget().removeListeners();
            this.getGraphWidget().setRedraw(false);
            GraphRepresentation representation = (GraphRepresentation)command.getRepresentation();
            EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.SCROLL_TO_TOP);
            if (this.fitToView()) {
                showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
            }
            this.getGraphWidget().show((GraphRepresentation)command.getRepresentation(), showOptions);
            this.getSelectionProviderAdapter().handleSelectionChanged();
            this.finishGraphCreation();
            if (this.getHighlightOriginalSelectionHandledItemId() != null) {
                this.updateHandledMenuItemState(this.getHighlightOriginalSelectionHandledItemId(), this.isOriginalSelectionHighlighted());
            }
            this.refreshUIElements();
            this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
            this.getGraphWidget().setRedraw(true);
            this.enableView();
            this.setViewReady(true);
            WorkbenchRegistry.getInstance().selectView(view);
        } else {
            this.removeRepresentationFromModel(command.getRepresentation(), false, false);
            this.hideView();
        }
    }

    @Override
    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, final boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        assert (options != null) : "Parameter 'option' of method 'showInView' must not be null";
        ViewNavigationManager.getInstance().clear(this.getViewId(), this.getSecondaryId());
        this.m_currentlySelectedNodes.clear();
        FocusMode focusMode = null;
        PresentationMode presentationMode = null;
        GraphMode graphMode = null;
        HashSet<CoreParserDependencyType> dependencyTypes = new HashSet<CoreParserDependencyType>();
        EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties = EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class);
        for (IStandardEnumeration option : options) {
            if (option instanceof FocusMode) {
                focusMode = (FocusMode)option;
                continue;
            }
            if (option instanceof PresentationMode) {
                presentationMode = (PresentationMode)option;
                continue;
            }
            if (option instanceof GraphMode) {
                graphMode = (GraphMode)option;
                continue;
            }
            if (option instanceof NodeAndEdgeRepresentation.RepresentationProperty) {
                properties.add((NodeAndEdgeRepresentation.RepresentationProperty)option);
                continue;
            }
            if (option instanceof CoreParserDependencyType) {
                dependencyTypes.add((CoreParserDependencyType)option);
                continue;
            }
            assert (false) : "Unexpected class '" + String.valueOf(option.getClass()) + "' in 'showInView'";
        }
        if (dependencyTypes.isEmpty()) {
            dependencyTypes.addAll(CollectionUtility.asSet((Object[])CoreParserDependencyType.values()));
        }
        HashSet<NamedElement> namedElements = new HashSet<NamedElement>();
        for (Element nextElement : elements) {
            assert (nextElement instanceof NamedElement) : "Not a named element: " + String.valueOf(nextElement);
            namedElements.add((NamedElement)nextElement);
        }
        int nameSuffix = -1;
        if (secondaryIdReused) {
            assert (this.m_graphWidget != null) : "'m_graphWidget' of method 'showInView' must not be null";
            NodeAndEdgeRepresentation currentRepresentation = this.m_graphWidget.getUnderlyingRepresentation();
            assert (currentRepresentation != null) : "'currentRepresentation' of method 'showInView' must not be null";
            nameSuffix = currentRepresentation.getId();
        }
        final CreateGraphRepresentationFromSelectionCommand command = new CreateGraphRepresentationFromSelectionCommand(this.getSoftwareSystemProvider(), namedElements, focusMode, presentationMode, properties, dependencyTypes, this.getEndpointType(), graphMode, nameSuffix, this.applyCycleAnalysis());
        this.setViewReady(false);
        if (command.isEnabled().isSuccess()) {
            UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.removeListeners();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        GraphRepresentation representation = (GraphRepresentation)command.getRepresentation();
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.REVEAL_INPUT, DrawableWidget.ShowOption.SCROLL_TO_TOP);
                        if (GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        GraphView.this.m_graphWidget.show(representation, showOptions);
                        GraphView.this.getSelectionProviderAdapter().handleSelectionChanged();
                        GraphView.this.finishGraphCreation();
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.refreshUIElements();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.performFinishShowInView(secondaryIdReused);
                    } else {
                        GraphView.this.removeRepresentationFromModel(command.getRepresentation(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    public void requestHome() {
        final NavigationState initialViewState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.getViewId(), this.getSecondaryId());
        assert (initialViewState != null) : "Parameter 'initialViewState' of method 'requestHome' must not be null";
        ViewNavigationManager.getInstance().clear(this.getViewId(), this.getSecondaryId());
        DrawableViewNavigationStateWrapper internalNavigationState = new DrawableViewNavigationStateWrapper(initialViewState, this.getElementResolver());
        GraphMode graphMode = null;
        Set dependencyTypes = internalNavigationState.getDependencyTypesForEdges();
        EnumSet properties = internalNavigationState.getProperties();
        if (properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)) {
            graphMode = properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY) ? GraphMode.TYPE_BASED_EXCLUDING_NESTED_TYPES : GraphMode.TYPE_BASED_INCLUDING_NESTED_TYPES;
        }
        final CreateGraphRepresentationForHomeRequestedCommand cmd = new CreateGraphRepresentationForHomeRequestedCommand(this.getSoftwareSystemProvider(), (GraphRepresentation)this.m_graphWidget.getUnderlyingRepresentation(), new HashSet(internalNavigationState.getMainNodes()), internalNavigationState.getFocusMode(), internalNavigationState.getPresentationMode(), properties, dependencyTypes, this.getEndpointType(), graphMode, this.applyCycleAnalysis());
        this.setViewReady(false);
        if (cmd.isEnabled().isSuccess()) {
            UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.removeListeners();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        GraphRepresentation representation = (GraphRepresentation)cmd.getRepresentation();
                        GraphView.this.m_graphWidget.show(representation, EnumSet.allOf(DrawableWidget.ShowOption.class));
                        GraphView.this.getSelectionProviderAdapter().handleSelectionChanged();
                        GraphView.this.getDrawableWidget().highlightOriginalInput();
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.m_graphWidget.home();
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.refreshUIElements();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.enableView();
                        GraphView.this.setViewReady(true);
                        ViewNavigationManager.getInstance().addNavigationState(initialViewState);
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.getRepresentation(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    protected final void focusRepresentationInView(Collection<RepresentationNode> elementsToFocus, Set<CoreParserDependencyType> dependencyTypes, FocusMode focusMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties) {
        FocusGraphRepresentationCommand cmd;
        assert (elementsToFocus != null) : "Parameter 'elementsToFocus' of method 'focusRepresentationInView' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'focusRepresentationInView' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'focusRepresentationInView' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'focusRepresentationInView' must not be null";
        assert (this.m_graphWidget != null) : " 'm_graphWidget' of method 'focusRepresentationInView' must not be null";
        NodeAndEdgeRepresentation underlyingRepresentation = this.m_graphWidget.getUnderlyingRepresentation();
        assert (underlyingRepresentation != null) : "'underlyingRepresentation' of method 'focusRepresentationInView' must not be null";
        EnumSet representationProperties = underlyingRepresentation.getRepresentationProperties();
        if (representationProperties.contains(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)) {
            properties.add(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH);
            if (underlyingRepresentation.getRepresentationProperties().contains(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)) {
                properties.add(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY);
            }
        }
        if ((cmd = new FocusGraphRepresentationCommand(this.getSoftwareSystemProvider(), this.getCurrentGraphRepresentation(), elementsToFocus, dependencyTypes, focusMode, properties)).isEnabled().isSuccess()) {
            UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.removeListeners();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.REVEAL_INPUT);
                        if (GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        GraphRepresentation representation = (GraphRepresentation)cmd.getRepresentation();
                        GraphView.this.m_graphWidget.show(representation, showOptions);
                        GraphView.this.getDrawableWidget().highlightOriginalInput();
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.saveViewState(GraphView.this.m_graphWidget, NavigationState.Type.CONTENT_FOCUSED);
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.refreshSelection();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.m_graphWidget.addListeners(GraphView.this);
                        GraphView.this.refreshUIElements();
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.getRepresentation(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    public List<Element> getSelectedElements() {
        if (!this.isReady() || this.m_graphWidget == null) {
            return Collections.emptyList();
        }
        return this.m_graphWidget.getCurrentlySelectedElements();
    }

    protected boolean applyCycleAnalysis() {
        return true;
    }

    @Override
    protected boolean needsRepresentationCreation(DrawableViewNavigationStateWrapper internalState) {
        boolean shouldChangePresentationMode;
        PresentationMode presentationMode;
        Set<Object> currentAdditionals;
        Set<Object> currentMainPathElements;
        assert (internalState != null) : "Parameter 'internalState' of method 'needsRepresentationCreation' must not be null";
        if (this.m_graphWidget.getUnderlyingRepresentation() != null) {
            currentMainPathElements = this.removeOnDemandCyclesFromCollection(this.m_graphWidget.getUnderlyingRepresentation().getMainNodes());
            currentAdditionals = this.removeOnDemandCyclesFromCollection(this.m_graphWidget.getUnderlyingRepresentation().getAdditionalNodes());
        } else {
            currentMainPathElements = Collections.emptySet();
            currentAdditionals = Collections.emptySet();
        }
        boolean elementsChanged = !CollectionUtility.collectionsContainSameElements((Collection)internalState.getMainNodes(), currentMainPathElements) || !CollectionUtility.collectionsContainSameElements((Collection)internalState.getAdditionalElements(), currentAdditionals);
        PresentationMode presentationMode2 = presentationMode = this.getDrawableWidget() != null ? this.getDrawableWidget().getPresentationMode() : null;
        boolean bl = presentationMode == null ? true : (shouldChangePresentationMode = presentationMode != internalState.getPresentationMode());
        return elementsChanged || shouldChangePresentationMode;
    }

    @Override
    protected final void finishCreateRepresentationForNavigation(final DrawableViewNavigationStateWrapper state) {
        assert (state != null) : "Parameter 'state' of method 'finishCreateRepresentation' must not be null";
        assert (!state.getNavigationState().isInvolvedInUndoRedoOperation()) : "Undo/Redo related states not supported in navigation, state id: " + state.getNavigationState().getId();
        NodeAndEdgeRepresentation currentRepresentation = this.getDrawableWidget().getUnderlyingRepresentation();
        assert (currentRepresentation != null && currentRepresentation instanceof GraphRepresentation) : "Unexpected class in method 'finishCreateRepresentation': " + String.valueOf(currentRepresentation);
        final CreateGraphRepresentationForNavigationCommand cmd = new CreateGraphRepresentationForNavigationCommand(this.getSoftwareSystemProvider(), (GraphRepresentation)currentRepresentation, state.getOriginalInput(), new HashSet(state.getMainNodes()), state.getAdditionalElements(), state.getDependencyTypesForEdges(), state.getFocusMode(), state.getPresentationMode(), state.getProperties(), state.getNavigationState().getId());
        if (cmd.isEnabled().isSuccess()) {
            this.disableView();
            UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.noneOf(DrawableWidget.ShowOption.class);
                        if (GraphView.this.autozoomEnabled() && GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        if (!((GraphRepresentation)cmd.getRepresentation()).getOriginalNodes().isEmpty()) {
                            showOptions.add(DrawableWidget.ShowOption.REVEAL_INPUT);
                        }
                        GraphView.this.m_graphWidget.show((GraphRepresentation)cmd.getRepresentation(), showOptions);
                        GraphView.this.applyNavigationState(state, !showOptions.contains((Object)DrawableWidget.ShowOption.FIT_TO_VIEW), CreateRepresentationMode.NAVIGATION);
                        GraphView.this.finishNonUndoRedoRepresentationCreation(cmd.getRepresentation(), state);
                        GraphView.this.enableView();
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.getRepresentation(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    public Set<NamedElement> removeOnDemandCyclesFromCollection(Collection<NamedElement> input) {
        assert (input != null) : "Parameter 'input' of method 'removeOnDemandCyclesFromCollection' must not be null";
        HashSet<NamedElement> withoutCycles = new HashSet<NamedElement>();
        for (NamedElement namedElement : input) {
            if (namedElement instanceof OnDemandCycleGroup) {
                withoutCycles.addAll(((OnDemandCycleGroup)namedElement).getCyclicNamedElements());
                continue;
            }
            withoutCycles.add(namedElement);
        }
        return withoutCycles;
    }

    @Override
    protected void applyNavigationState(DrawableViewNavigationStateWrapper state, boolean applyZoomFromState, CreateRepresentationMode createRepresentationMode) {
        assert (state != null) : "Parameter 'state' of method 'applyNavigationState' must not be null";
        Collection selected = state.getSelection();
        Collection selectedConnections = state.getEndPointSelection();
        ArrayList<IDrawableFigure> items = new ArrayList<IDrawableFigure>(selected.size() + selectedConnections.size());
        for (NamedElement element : selected) {
            IDrawableNode node = this.m_graphWidget.getNode(element);
            if (node == null) continue;
            items.add(node);
        }
        for (Pair dependency : selectedConnections) {
            IDrawableNode.IDrawableEdge<? extends IDrawableNode> connection = this.m_graphWidget.getConnection((Pair<NamedElement, NamedElement>)dependency);
            if (connection == null) continue;
            items.add(connection);
        }
        this.m_graphWidget.setSelection(items, true);
        if (this.isHighlightInputMenuItemSelected()) {
            this.m_graphWidget.highlightOriginalInput();
        }
        if (applyZoomFromState) {
            this.m_graphWidget.setZoomLevel(state.getZoomLevel());
        }
        StructuredSelection selection = new StructuredSelection(this.m_graphWidget.getSelectedElements().toArray());
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)selection);
        if (createRepresentationMode == CreateRepresentationMode.NAVIGATION) {
            NodeAndEdgeRepresentation representation = this.getDrawableWidget().getUnderlyingRepresentation();
            assert (representation != null) : "'representation' of method 'applyNavigationState' must not be null";
            representation.applyProgrammingElementCollectionsState(state.getNavigationState().getId());
        }
        this.refreshUIElements();
        this.refreshSelection();
        this.updateHandledMenuItemState(this.getHighlightOriginalSelectionHandledItemId(), this.isOriginalSelectionHighlighted());
    }

    @Override
    public final DrawableWidget getDrawableWidget() {
        return this.m_graphWidget;
    }

    @Override
    public boolean startElementsMoveInteraction(Gesture gesture, List<Element> selectedElements) {
        assert (gesture != null) : "Parameter 'gesture' of method 'startElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'startElementsMoveInteraction' must not be null";
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof RepresentationNode) {
            switch (gesture) {
                case MOVE_ELEMENT_COMPOSITE: {
                    return false;
                }
                case MOVE_ELEMENT_SIMPLE: {
                    return true;
                }
            }
            assert (false) : "Unhandled gesture: " + String.valueOf((Object)gesture);
        }
        return false;
    }

    protected void setLocation(GraphNodeFigure node, Point targetLocation, boolean allowYAxisDragging) {
        assert (node != null) : "Parameter 'node' of method 'setLocation' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'setLocation' must not be null";
        int xLocation = targetLocation.x - Math.round((float)node.getSize().width / 2.0f);
        int yLocation = allowYAxisDragging ? targetLocation.y - node.getSize().height / 2 : node.getLocation().y;
        xLocation = Math.max(xLocation, 0);
        yLocation = Math.max(yLocation, 0);
        node.setLocation(new Point(xLocation, yLocation));
    }

    @Override
    public void inElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, Point sourceLocation, Point targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'inElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'inElementsMoveInteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'inElementsMoveInteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'inElementsMoveInteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (false) : "Not supported";
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                assert (selectedElements.size() == 1) : "Exactly on element expected";
                Element element = selectedElements.get(0);
                assert (element != null && element instanceof RepresentationNode) : "Unexpected class in method 'inElementsMoveInteraction': " + String.valueOf(element);
                GraphNodeFigure node = (GraphNodeFigure)this.m_graphWidget.getNode(((RepresentationNode)element).getUnderlyingObject());
                this.setLocation(node, targetLocation, this.allowYAxisDragging());
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + String.valueOf((Object)gesture);
                break;
            }
        }
    }

    @Override
    public void finishElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, Point sourceLocation, Point targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'finishElementsMoveInnteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'finishElementsMoveInnteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'finishElementsMoveInnteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (false) : "Not supported";
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                this.m_graphWidget.reLayout(true);
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + String.valueOf((Object)gesture);
                break;
            }
        }
    }

    protected boolean allowYAxisDragging() {
        return false;
    }

    protected final GraphWidget getGraphWidget() {
        return this.m_graphWidget;
    }

    @Override
    protected final IFigure getFigureForImageExport() {
        assert (this.m_graphWidget != null) : "'m_graphWidget' of method 'getFigureForImageExport' must not be null";
        return this.m_graphWidget.getFigureCanvas().getContents();
    }

    public EndpointType getEndpointType() {
        return EndpointType.PARSER_DEPENDENCY;
    }

    protected void finishGraphCreation() {
        this.getDrawableWidget().highlightOriginalInput();
    }

    @Override
    public final void nodeSelected(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeSelected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
        }
    }

    @Override
    public final void nodeDeselected(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeDeselected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
        }
    }

    @Override
    public final void edgeSelected(RepresentationEdge<RepresentationNode> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'edgeSelected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
        }
    }

    @Override
    public final void edgeDeselected(RepresentationEdge<RepresentationNode> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'edgeDeselected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
        }
    }

    protected CreateRepresentationCommand<GraphRepresentation> getCommandForPresentationModification(NodeAndEdgeRepresentation representation, PresentationMode presentationMode) {
        assert (representation != null && representation instanceof GraphRepresentation) : "Unexpected class in method 'getCommandForPresentationModification': " + String.valueOf(representation);
        return new CreateGraphForPresentationModeChangeCommand(this.getSoftwareSystemProvider(), (GraphRepresentation)representation, presentationMode);
    }

    @Override
    public void canvasClicked() {
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
        }
    }

    @Override
    public List<IStandardEnumeration> getAdditionalShowInViewOptions() {
        ArrayList<IStandardEnumeration> options = new ArrayList<IStandardEnumeration>(1);
        if (this.getDrawableWidget().getUnderlyingRepresentation() == null) {
            options.add((IStandardEnumeration)PresentationMode.HIERARCHICAL);
        } else {
            PresentationMode presentationMode = this.getDrawableWidget().getPresentationMode();
            assert (presentationMode != null) : "'presentationMode' of method 'getAdditionalShowInViewOptions' must not be null";
            options.add((IStandardEnumeration)presentationMode);
        }
        return options;
    }

    @Override
    protected ExtendFocusCommand<? extends NodeAndEdgeRepresentation> getExtendFocusCommand(ISoftwareSystemProvider provider, NodeAndEdgeRepresentation currentRepresentation, List<Element> selection, boolean onlyVisible) {
        assert (provider != null) : "Parameter 'provider' of method 'getExtendFocusCommand' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'getExtendFocusCommand' must not be null";
        assert (selection != null) : "Parameter 'elementsToFocus' of method 'getExtendFocusCommand' must not be null";
        return new ExtendGraphFocusCommand(provider, (GraphRepresentation)currentRepresentation, selection, onlyVisible);
    }

    @Override
    protected RemoveFromFocusCommand<? extends NodeAndEdgeRepresentation> getRemoveFromFocusCommand(ISoftwareSystemProvider provider, NodeAndEdgeRepresentation currentRepresentation, List<Element> selection) {
        assert (provider != null) : "Parameter 'provider' of method 'getRemoveFromFocusCommand' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'getRemoveFromFocusCommand' must not be null";
        assert (selection != null) : "Parameter 'elementsToRemoveFromFocus' of method 'getRemoveFromFocusCommand' must not be null";
        return new RemoveFromGraphFocusCommand(provider, (GraphRepresentation)currentRepresentation, selection);
    }

    @Override
    protected String getHighlightOriginalSelectionHandledItemId() {
        return HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID;
    }

    @Override
    protected String getShowOnlyDependenciesOfSelectedNodesHandledItemId() {
        return SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID;
    }

    @Override
    protected String getShowOnlyViolationsHandledItemId() {
        return SHOW_ONLY_VIOLATIONS;
    }

    @Override
    protected String getHideSelfArcsHandledItemId() {
        return HIDE_SELF_ARCS;
    }

    @Override
    protected String getOnlyVisibleHandledItemId() {
        return SHOW_ONLY_VISIBLE_TOOLITEM_ID;
    }

    public static enum UnbalancedElementGroup implements IElementGroup
    {
        UNBALANCED_ELEMENTS;

    }
}

