/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;

final class GeometryUtility {
    private GeometryUtility() {
    }

    static boolean ellipseContainsPoint(Rectangle ellipseBounds, int x, int y, int toleranceBySide) {
        assert (ellipseBounds != null) : "Parameter 'ellipseBounds' of method 'ellipseContainsPoint' must not be null";
        Pair<Rectangle, Rectangle> containsPointArea = GeometryUtility.getContainsPointRegion(ellipseBounds, toleranceBySide);
        Rectangle inner = (Rectangle)containsPointArea.getFirst();
        Rectangle outer = (Rectangle)containsPointArea.getSecond();
        if (ellipseBounds.height == 0 || ellipseBounds.width == 0) {
            return false;
        }
        int h = ellipseBounds.x + ellipseBounds.width / 2;
        int k = ellipseBounds.y + ellipseBounds.height / 2;
        return GeometryUtility.checkPointIsOnOrNearEllipse(x, y, h, k, ellipseBounds, inner, outer);
    }

    private static Pair<Rectangle, Rectangle> getContainsPointRegion(Rectangle paintArea, int toleranceBySide) {
        assert (paintArea != null) : "Parameter 'paintArea' of method 'getContainsPointRegion' must not be null";
        Rectangle outer = new Rectangle(paintArea);
        outer.x -= toleranceBySide;
        outer.y -= toleranceBySide;
        outer.width += toleranceBySide * 2;
        outer.height += toleranceBySide * 2;
        Rectangle inner = new Rectangle(paintArea);
        inner.x += toleranceBySide;
        inner.y += toleranceBySide;
        inner.width -= toleranceBySide * 2;
        inner.height -= toleranceBySide * 2;
        return new Pair((Object)inner, (Object)outer);
    }

    private static boolean checkPointIsOnOrNearEllipse(int x, int y, int h, int k, Rectangle paintArea, Rectangle inner, Rectangle outer) {
        int outterMajorAxis = outer.height;
        int outterMinorAxis = outer.width;
        double firstOutter = Math.pow(x - h, 2.0) / Math.pow((double)outterMinorAxis / 2.0, 2.0);
        double secondOutter = Math.pow(y - k, 2.0) / Math.pow((double)outterMajorAxis / 2.0, 2.0);
        double resultOutter = firstOutter + secondOutter;
        int innerMajorAxis = inner.height;
        int innerMinorAxis = inner.width;
        double firstInner = Math.pow(x - h, 2.0) / Math.pow((double)innerMinorAxis / 2.0, 2.0);
        double secondInner = Math.pow(y - k, 2.0) / Math.pow((double)innerMajorAxis / 2.0, 2.0);
        double resultInner = firstInner + secondInner;
        double first = Math.pow(x - h, 2.0) / Math.pow((double)paintArea.width / 2.0, 2.0);
        double second = Math.pow(y - k, 2.0) / Math.pow((double)paintArea.height / 2.0, 2.0);
        double result = first + second;
        return resultOutter < 1.0 && resultInner > 1.0 && result > resultOutter && result < resultInner;
    }
}

