/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog.feedback;

import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackComposite;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class FeedbackOnErrorDialog
extends MessageDialog {
    private static final String DETAILS_INTRO_TEXT = "Please consider providing additional context information to help us fixing the issue.\nIf you provide your contact details we will inform you about the progress.";
    private static final String DONT_SENDERROREMAIL = "Feedback_Dont_Send_Error_Email";
    public static final int SHOW_DETAILS_INDEX = 0;
    public static final int CLOSE_BUTTON_INDEX = 1;
    public static final int CONTINUE_BUTTON_INDEX = 2;
    private final Throwable m_throwable;
    private boolean m_sendErrorEmail;
    private boolean m_attachLogFile;
    private Button m_sendEmailCheckBox;
    private Composite m_parentComposite;
    private FeedbackComposite m_feedbackComposite;
    private Feedback.Salutation m_salutation;
    private String m_contactName = "";
    private String m_email = "";
    private String m_phone = "";
    private final TFile m_logFile;
    private String m_contextInfo = "";
    private ErrorComposite m_errorComposite;
    private final String m_bundleId;
    private final IProxySettingsProvider m_proxySettingsProvider;
    private final String m_infoText;

    public FeedbackOnErrorDialog(Shell parentShell, Throwable throwable, TFile logFile, String bundleId, IProxySettingsProvider proxySettingsProvider, String infoText, String[] additionalButtons, int defaultIndex) {
        super(parentShell, SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + " - Error", null, "We are sorry, but an unexpected error occurred.", 1, additionalButtons, defaultIndex);
        assert (throwable != null) : "Parameter 'throwable' of method 'FeedbackOnErrorDialog' must not be null";
        assert (logFile != null) : "Parameter 'logFile' of method 'StandardErrorDialog' must not be null";
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'FeedbackOnErrorDialog' must not be empty";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'FeedbackOnErrorDialog' must not be null";
        assert (infoText != null && infoText.length() > 0) : "Parameter 'infoText' of method 'FeedbackOnErrorDialog' must not be empty";
        this.m_logFile = logFile;
        this.m_throwable = throwable;
        this.m_bundleId = bundleId;
        this.m_proxySettingsProvider = proxySettingsProvider;
        this.m_infoText = infoText;
        IEclipsePreferences settings = PreferencesUtility.getPreferences(bundleId, UiSwtDialogId.FEEDBACK_DIALOG);
        assert (settings != null) : "settings must not be null";
        this.m_salutation = FeedbackComposite.initSalutationFromPreferences(settings);
        this.m_contactName = settings.get("Feedback_Contact_Name", "");
        this.m_email = settings.get("Feedback_Email", "");
        this.m_phone = settings.get("Feedback_Phone", "");
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'configureShell' must not be null";
        super.configureShell(shell);
        shell.setImage(UiResourceManager.getInstance().getImage("icon_64x64"));
    }

    private IDialogId getDialogId() {
        return UiSwtDialogId.FEEDBACK_ON_ERROR_DIALOG;
    }

    private String getBundleId() {
        return this.m_bundleId;
    }

    protected Control createCustomArea(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'fillDialogArea' must not be null";
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(this.m_infoText);
        Label alanImage = new Label(composite, 0);
        String image = System.currentTimeMillis() % 2L == 0L ? "Alan" : "Bob";
        alanImage.setImage(UiResourceManager.getInstance().getImage(image));
        alanImage.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_sendEmailCheckBox = new Button(composite, 32);
        this.m_sendEmailCheckBox.setText("Send error report");
        this.m_sendEmailCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedbackOnErrorDialog.this.m_sendErrorEmail = FeedbackOnErrorDialog.this.m_sendEmailCheckBox.getSelection();
            }
        });
        this.m_sendEmailCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_feedbackComposite = new FeedbackOnErrorComposite(composite, new FeedbackComposite.IListener(){

            @Override
            public void modified() {
                if (FeedbackOnErrorDialog.this.m_feedbackComposite.getConnectionMode() == ConnectionMode.ONLINE) {
                    FeedbackOnErrorDialog.this.m_sendErrorEmail = FeedbackOnErrorDialog.this.m_sendEmailCheckBox.getSelection();
                    FeedbackOnErrorDialog.this.m_sendEmailCheckBox.setEnabled(true);
                } else {
                    FeedbackOnErrorDialog.this.m_sendEmailCheckBox.setEnabled(false);
                    FeedbackOnErrorDialog.this.m_sendErrorEmail = false;
                }
            }
        }, 0, 2, DETAILS_INTRO_TEXT, this.m_logFile, false, this.m_bundleId, this.m_proxySettingsProvider);
        GridData layoutData = new GridData(4, 4, true, true, 2, 1);
        this.m_feedbackComposite.setLayoutData(layoutData);
        if (this.m_contactName != null) {
            this.m_feedbackComposite.setContactName(this.m_contactName);
        }
        if (this.m_email != null) {
            this.m_feedbackComposite.setEmail(this.m_email);
        }
        if (this.m_phone != null) {
            this.m_feedbackComposite.setPhone(this.m_phone);
        }
        if (this.m_contextInfo != null) {
            this.m_feedbackComposite.setContextInfo(this.m_contextInfo);
        }
        IEclipsePreferences settings = PreferencesUtility.getPreferences(this.getBundleId(), this.getDialogId());
        assert (settings != null) : "settings must not be null";
        this.m_sendEmailCheckBox.setSelection(!settings.getBoolean(DONT_SENDERROREMAIL, false));
        this.m_sendErrorEmail = this.m_sendEmailCheckBox.getSelection() && this.m_feedbackComposite.getConnectionMode() == ConnectionMode.ONLINE;
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.m_parentComposite = parent;
        this.getShell().setDefaultButton(this.getButton(1));
        return control;
    }

    public boolean sendErrorEmail() {
        return this.m_sendErrorEmail;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 0) {
            super.buttonPressed(buttonId);
            return;
        }
        Button detailsButton = this.getButton(0);
        if (detailsButton.getText().equals(IDialogConstants.SHOW_DETAILS_LABEL)) {
            detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.m_errorComposite = new ErrorComposite(this.m_parentComposite, 0);
            this.m_errorComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        } else {
            detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            this.m_errorComposite.setVisible(false);
            this.m_errorComposite.dispose();
        }
        Point previousSize = this.getShell().getSize();
        Point desiredSize = this.getShell().computeSize(-1, -1, true);
        this.getShell().setSize(previousSize.x, desiredSize.y);
    }

    public boolean close() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences(this.getBundleId(), this.getDialogId());
        assert (settings != null) : "settings must not be null";
        settings.putBoolean(DONT_SENDERROREMAIL, !this.m_sendErrorEmail);
        settings.putBoolean("Feedback_Dont_Attach_Logfile", !this.m_attachLogFile);
        if (this.m_feedbackComposite != null) {
            this.m_feedbackComposite.storeSettings();
            this.m_salutation = this.m_feedbackComposite.getSalutation();
            this.m_contactName = this.m_feedbackComposite.getContactName();
            this.m_email = this.m_feedbackComposite.getEmail();
            this.m_phone = this.m_feedbackComposite.getPhone();
            this.m_contextInfo = this.m_feedbackComposite.getContextInfo();
        }
        PreferencesUtility.save(settings);
        return super.close();
    }

    public Feedback.Salutation getSalutation() {
        return this.m_salutation;
    }

    public String getContactName() {
        return this.m_contactName;
    }

    public String getEmail() {
        return this.m_email;
    }

    public String getPhone() {
        return this.m_phone;
    }

    public String getContextInfo() {
        return this.m_contextInfo;
    }

    private class ErrorComposite
    extends Composite {
        private final Button m_attachLogFileCheckBox;

        public ErrorComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(1));
            Composite composite = new Composite((Composite)this, style);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(2));
            Label contactLabel = new Label(composite, 0);
            contactLabel.setText("Contact name: ");
            contactLabel.setForeground(contactLabel.getBackground());
            Label dummyLabel2 = new Label(composite, 0);
            dummyLabel2.setText("");
            Label errorLabel = new Label(composite, 0);
            errorLabel.setText("Exception: ");
            errorLabel.setLayoutData((Object)new GridData(1, 128, false, false));
            Text detailsText = new Text(composite, 2826);
            GridData layoutDataException = new GridData(4, 4, true, true);
            layoutDataException.heightHint = 200;
            detailsText.setLayoutData((Object)layoutDataException);
            detailsText.setText(ExceptionUtility.collectAll((Throwable)FeedbackOnErrorDialog.this.m_throwable));
            Label logFileLabel = new Label(composite, 0);
            logFileLabel.setText("Log file: ");
            logFileLabel.setLayoutData((Object)new GridData(128, 1, false, false));
            this.m_attachLogFileCheckBox = new Button(composite, 32);
            this.m_attachLogFileCheckBox.setLayoutData((Object)new GridData(1, 128, false, false));
            this.m_attachLogFileCheckBox.setText("Attach log file");
            this.m_attachLogFileCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ErrorComposite)ErrorComposite.this).FeedbackOnErrorDialog.this.m_attachLogFile = ErrorComposite.this.m_attachLogFileCheckBox.getSelection();
                }
            });
            SwtUtility.createFillerForGridLayoutCell(composite);
            IEclipsePreferences settings = PreferencesUtility.getPreferences(FeedbackOnErrorDialog.this.getBundleId(), FeedbackOnErrorDialog.this.getDialogId());
            assert (settings != null) : "settings must not be null";
            FeedbackOnErrorDialog.this.m_attachLogFile = !settings.getBoolean("Feedback_Dont_Attach_Logfile", false);
            this.m_attachLogFileCheckBox.setSelection(FeedbackOnErrorDialog.this.m_attachLogFile);
            Link logFileLink = new Link(composite, 0);
            GridData layoutData = new GridData(4, 128, true, false);
            layoutData.widthHint = 300;
            logFileLink.setLayoutData((Object)layoutData);
            final String logFilePath = FeedbackOnErrorDialog.this.m_logFile.getNormalizedAbsolutePath();
            logFileLink.setText("<a>" + logFilePath + "</a>");
            logFileLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Program.launch((String)logFilePath);
                }
            });
        }
    }

    private class FeedbackOnErrorComposite
    extends FeedbackComposite {
        public FeedbackOnErrorComposite(Composite parent, FeedbackComposite.IListener listener, int style, int columns, String introText, TFile logFile, boolean showSubject, String bundleId, IProxySettingsProvider provider) {
            super(parent, listener, provider, style, columns, introText, logFile, showSubject, bundleId);
        }

        @Override
        protected boolean validateInputFields() {
            return false;
        }
    }
}

