/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkbenchAuxiliaryView
extends WorkbenchView {
    public static final String WORKBENCH_AUXILIARY_VIEW_OPTION_CHANGED = "WorkbenchAuxiliaryViewOptionChanged";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchAuxiliaryView.class);
    private WorkbenchView m_connectedToView;

    protected WorkbenchAuxiliaryView() {
    }

    public final WorkbenchView getConnectedView() {
        return this.m_connectedToView;
    }

    @Override
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    @Override
    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.of(Gesture.DOUBLE_CLICK);
    }

    protected abstract boolean canConnect(WorkbenchView var1, boolean var2);

    protected void connect(WorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'connect' must not be null";
        this.m_connectedToView = view;
    }

    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
    }

    protected void disconnect() {
        if (this.m_connectedToView != null) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Disconnect from '" + String.valueOf(this.m_connectedToView.getViewId()) + "'.");
        } else {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Cannot disconnect - no connected view.");
        }
        this.m_connectedToView = null;
    }

    protected final void initialize(WorkbenchView view) {
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Initialize.");
        if (view != null) {
            if (this.canConnect(view, false)) {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Connect to '" + String.valueOf(view.getViewId()) + "'.");
                this.connect(view);
                assert (this.m_connectedToView != null) : "'m_connectedToView' of method 'initialize' must not be null";
                this.handleSelection(this.m_connectedToView, this.m_connectedToView.getSelectedElements());
            } else {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Cannot connect to '" + String.valueOf(view.getViewId()) + "'.");
            }
        } else {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] No view to connect to.");
        }
    }

    private WorkbenchView getConnectToCandidate() {
        List<IWorkbenchView> views = WorkbenchRegistry.getInstance().getViewSelectionChain();
        if (LOGGER.isDebugEnabled()) {
            for (IWorkbenchView next : views) {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Connect-to-candidate '" + String.valueOf(next.getViewId()) + "'.");
            }
        }
        ListIterator<IWorkbenchView> iter = views.listIterator(views.size());
        while (iter.hasPrevious()) {
            IWorkbenchView next = iter.previous();
            if (!(next instanceof WorkbenchView) || next instanceof WorkbenchAuxiliaryView) continue;
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Determined connect-to-candidate '" + String.valueOf(next.getViewId()) + "'.");
            return (WorkbenchView)next;
        }
        return null;
    }

    protected void initialize() {
        this.initialize(this.getConnectToCandidate());
    }

    @Override
    protected final void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (view != null && this.m_connectedToView == view) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Handle selection connected to '" + String.valueOf(this.m_connectedToView.getViewId()) + "'.");
            this.handleSelection(this.m_connectedToView, elements);
        }
    }

    private void updateConnectionState(IWorkbenchView view, boolean force, String debugContext) {
        assert (debugContext != null && debugContext.length() > 0) : "Parameter 'debugContext' of method 'updateConnectionState' must not be empty";
        if (view != this) {
            WorkbenchView newCanConnectTo;
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Update connection state for (" + debugContext + ") '" + String.valueOf(view.getViewId()) + "'" + (force ? " [force]" : ""));
            WorkbenchView workbenchView = newCanConnectTo = this.canConnect((WorkbenchView)view, force) ? (WorkbenchView)view : null;
            if (newCanConnectTo != null) {
                if (force || this.m_connectedToView != newCanConnectTo) {
                    if (this.m_connectedToView != null) {
                        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Disconnect from (" + debugContext + "): '" + String.valueOf(this.m_connectedToView.getViewId()) + "'.");
                        this.disconnect();
                    }
                    LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Connect to  (" + debugContext + "): '" + String.valueOf(newCanConnectTo.getViewId()) + "'.");
                    this.connect(newCanConnectTo);
                    LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Handle selection.");
                    this.handleSelection(this.m_connectedToView, this.m_connectedToView.getSelectedElements());
                }
            } else {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Cannot connect to '" + String.valueOf(view.getViewId()) + "'." + (String)(this.m_connectedToView != null ? " Keep connection to '" + String.valueOf(this.m_connectedToView.getViewId()) + "'." : ""));
            }
        }
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemShow' must not be null";
        WorkbenchView currentlySelected = this.getConnectToCandidate();
        if (currentlySelected != null) {
            this.updateConnectionState(currentlySelected, mode == WorkbenchView.ShowMode.AWAKE, "softwareSystemShow");
        }
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemHide' must not be null";
        if (mode == WorkbenchView.HideMode.ASLEEP) {
            this.m_connectedToView = null;
        }
        super.softwareSystemHide(mode);
    }

    @Override
    protected void performViewSelected(IWorkbenchView view) {
        if (view != null) {
            this.updateConnectionState(view, false, "'performViewSelected'");
        }
        super.performViewSelected(view);
    }

    @Override
    protected void performViewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'performViewClosed' must not be null";
        if (this.m_connectedToView == view) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Disconnect from (in 'viewClosed'): '" + String.valueOf(view.getViewId()) + "'.");
            this.disconnect();
        }
        super.performViewClosed(view);
    }

    @Override
    protected void destroyViewContent() {
        if (this.m_connectedToView != null) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Disconnect from (in 'destroyViewContent'): '" + String.valueOf(this.m_connectedToView.getViewId()) + "'.");
            this.disconnect();
        }
        super.destroyViewContent();
    }
}

