/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.Collections;
import java.util.List;

public final class DuplicatesSourceViewShowInViewSupport
extends SupportsShowInView {
    DuplicatesSourceViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    private List<Element> getElementsForShowInView(List<Element> selectedElements) {
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'getElementsForShowInView' must not be null";
        if (selectedElements.isEmpty()) {
            return null;
        }
        if (selectedElements.size() == 1) {
            Issue selectedIssue;
            Element element = selectedElements.get(0);
            if (element instanceof IDiffElement) {
                IDiffElement issueDiff = (IDiffElement)element;
                if (issueDiff.getCurrentElement() == null) {
                    return null;
                }
                element = issueDiff.getCurrentElement();
            } else if (element instanceof IssueRank) {
                element = ((IssueRank)element).getRankedElement();
            }
            if (element instanceof Issue && (selectedIssue = (Issue)element).getAffectedElement() instanceof DuplicateCodeBlock) {
                element = selectedIssue.getAffectedElement();
            }
            if (element instanceof DuplicateCodeBlock) {
                return Collections.singletonList(element);
            }
            if (element instanceof DuplicateCodeBlockOccurrence) {
                return Collections.singletonList(((DuplicateCodeBlockOccurrence)element).getParent());
            }
        }
        if (selectedElements.size() > 1) {
            for (Element element : selectedElements) {
                if (element instanceof DuplicateCodeBlockOccurrence) continue;
                return null;
            }
            if (selectedElements.get(0) instanceof DuplicateCodeBlock) {
                return null;
            }
            if (selectedElements.get(0) instanceof DuplicateCodeBlockOccurrence) {
                NamedElement parent = null;
                for (Element element : selectedElements) {
                    if (element instanceof DuplicateCodeBlock) {
                        return null;
                    }
                    DuplicateCodeBlockOccurrence occurrence = (DuplicateCodeBlockOccurrence)element;
                    if (parent == null) {
                        parent = occurrence.getParent();
                        continue;
                    }
                    if (parent.equals(occurrence.getParent())) continue;
                    return null;
                }
                return selectedElements;
            }
        }
        return null;
    }

    private String getStringForSecondaryId(List<Element> elementsForShowInView) {
        assert (elementsForShowInView != null && !elementsForShowInView.isEmpty()) : "Parameter 'elementsForShowInView' of method 'properlySelected' must not be empty";
        Element first = elementsForShowInView.get(0);
        if (first instanceof DuplicateCodeBlock) {
            return first.getName();
        }
        assert (first instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'properlySelected': " + String.valueOf(first);
        return ((DuplicateCodeBlockOccurrence)first).getParent().getName();
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        List<Element> elementsForShowInView;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.DUPLICATE_CODE) && (elementsForShowInView = this.getElementsForShowInView(selectedElements)) != null) {
            String secondaryIdInput = this.getStringForSecondaryId(elementsForShowInView);
            return new ShowInView(new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, this.getSecondaryId(secondaryIdInput)));
        }
        return null;
    }
}

