/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.draw2d.FigureCanvas;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.SWTGraphics;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ImageExtension;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class CanvasImageExporter {
    private CanvasImageExporter() {
    }

    public static OperationResult exportToImage(FigureCanvas canvas, TFile targetFile) {
        assert (canvas != null) : "Parameter 'canvas' of method 'exportToImage' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportImage' must not be null";
        OperationResult result = new OperationResult("Export image to '" + targetFile.getAbsolutePath() + "'");
        String targetFileExtension = FileUtility.getExtension((TFile)targetFile);
        int imageType = ImageExtension.getSwtImageType(targetFileExtension);
        Image image = null;
        GC gc = null;
        SWTGraphics graphics = null;
        try {
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (TFileOutputStream outputStream = new TFileOutputStream((File)targetFile);){
                    Rectangle figureBounds = canvas.getContents().getBounds();
                    image = new Image((Device)WorkbenchRegistry.getInstance().getDisplay(), figureBounds.width, figureBounds.height);
                    gc = new GC((Drawable)image);
                    gc.setAntialias(1);
                    graphics = new SWTGraphics(gc);
                    graphics.translate(-figureBounds.x, -figureBounds.y);
                    canvas.getContents().paint(graphics);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    imageLoader.save((OutputStream)outputStream, imageType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_FILE, e, "Failed to export image.", new Object[0]);
                if (graphics != null) {
                    graphics.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result;
    }
}

