/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureIssueWithLineNumber;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IAdditionalShowInViewOption;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitectureFileViewShowInViewSupport
extends SupportsShowInView {
    public ArchitectureFileViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    private static FileTargetValue getFileTargetValue(IArchitectureElement element) {
        assert (element != null) : "Parameter 'element' of method 'getFileTargetValue' must not be null";
        return FileTargetValue.ARTEFACT;
    }

    private static FileTargetValue getFileTargetValue(Artifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'getFileTargetValue' must not be null";
        if (artifact.isRequired()) {
            if (artifact.isUnrestricted()) {
                return FileTargetValue.ARTEFACT_UNRESTRICTED_REQUIRED;
            }
            if (artifact.isStrict()) {
                return FileTargetValue.ARTEFACT_STRICT_REQUIRED;
            }
            if (artifact.isRelaxed()) {
                return FileTargetValue.ARTEFACT_RELAXED_REQUIRED;
            }
            return FileTargetValue.ARTEFACT_REQUIRED;
        }
        if (artifact.isApplied()) {
            if (artifact.isUnrestricted()) {
                return FileTargetValue.ARTEFACT_UNRESTRICTED_APPLIED;
            }
            if (artifact.isStrict()) {
                return FileTargetValue.ARTEFACT_STRICT_APPLIED;
            }
            if (artifact.isRelaxed()) {
                return FileTargetValue.ARTEFACT_RELAXED_APPLIED;
            }
            return FileTargetValue.ARTEFACT_APPLIED;
        }
        return null;
    }

    public static List<FileTarget> getArchitectureFileTargets(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getArchitectureFileTargets' must not be null";
        if (elements.size() == 1) {
            Artifact artifact;
            FileTargetValue fileTargetValue;
            Element element = elements.get(0);
            Issue issue = null;
            if (element instanceof Issue) {
                issue = (Issue)element;
                element = ((Issue)element).getAffectedElement();
            }
            ArrayList<FileTarget> targets = new ArrayList<FileTarget>(2);
            if (element instanceof ArchitectureElement) {
                ArchitectureElement architectureElement = (ArchitectureElement)element;
                if (issue != null) {
                    int lineNumber = architectureElement.getContextLineNumber();
                    if (issue instanceof ArchitectureIssueWithLineNumber) {
                        lineNumber = issue.getLineNumber();
                    }
                    targets.add(new FileTarget(ArchitectureFileViewShowInViewSupport.getFileTargetValue((IArchitectureElement)architectureElement), (ArchitectureFile)architectureElement.getParent(ArchitectureFile.class, new Class[0]), lineNumber));
                } else {
                    targets.add(new FileTarget(ArchitectureFileViewShowInViewSupport.getFileTargetValue((IArchitectureElement)architectureElement), (ArchitectureFile)architectureElement.getDefiningFile(), element.getLineNumber()));
                }
            } else if (element instanceof ArchitectureFile) {
                int lineNumber = -1;
                if (issue != null) {
                    lineNumber = issue.getLineNumber();
                }
                targets.add(new FileTarget(FileTargetValue.ARCHITECTURE_FILE, (ArchitectureFile)element, lineNumber));
            }
            if (element instanceof Artifact && (fileTargetValue = ArchitectureFileViewShowInViewSupport.getFileTargetValue(artifact = (Artifact)element)) != null) {
                targets.add(new FileTarget(fileTargetValue, (ArchitectureFile)artifact.getParent(ArchitectureFile.class, new Class[0]), artifact.getReferencedFromLineNumber()));
            }
            return targets;
        }
        return Collections.emptyList();
    }

    private boolean isArchitectureRelated(Element element) {
        assert (element != null) : "Parameter 'element' of method 'isArchitectureRelated' must not be null";
        return element instanceof IArchitectureElement || element instanceof ArchitectureFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Element> getElementsForShowInView(List<Element> elements) {
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'getElementsForShowInView' must not be null";
        if (elements.size() != 1) return null;
        Element candidate = elements.get(0);
        if (candidate instanceof IDiffElement) {
            Element current = ((IDiffElement)candidate).getCurrentElement();
            if (current == null) {
                return null;
            }
            element = current;
        } else if (candidate instanceof INamedElementAdapter) {
            List adaptedTo = ((INamedElementAdapter)candidate).getAdaptedTo();
            if (adaptedTo.size() != 1) return null;
            element = (Element)adaptedTo.get(0);
        } else {
            element = candidate;
        }
        if (!this.isArchitectureRelated(element) && (!(element instanceof Issue) || !this.isArchitectureRelated(((Issue)element).getAffectedElement()))) return null;
        return Collections.singletonList(element);
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        List<FileTarget> architectureFileTargets;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        List<Element> elementsForShowInView = this.getElementsForShowInView(selectedElements);
        if (elementsForShowInView != null && !(architectureFileTargets = ArchitectureFileViewShowInViewSupport.getArchitectureFileTargets(elementsForShowInView)).isEmpty()) {
            if (architectureFileTargets.size() == 1) {
                FileTarget fileTarget = architectureFileTargets.get(0);
                ShowInViewNode entry = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, fileTarget.getFilePath().getFileId());
                entry.addOption(fileTarget.getFileTargetValue());
                return new ShowInView(entry);
            }
            ShowInViewNode rootMenuNode = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true);
            for (FileTarget nextFileTarget : architectureFileTargets) {
                ShowInViewNode definitionEntry = new ShowInViewNode(rootMenuNode.getElements(), nextFileTarget.getFileTargetValue().getPresentationName(), nextFileTarget.getFileTargetValue().getImageResourceName(), false, nextFileTarget.getFilePath().getFileId());
                definitionEntry.addOption(nextFileTarget.getFileTargetValue());
                rootMenuNode.addChild(definitionEntry);
            }
            return new ShowInView(rootMenuNode);
        }
        return null;
    }

    public static FileTarget getArchitectureFileTarget(List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArchitectureFileTarget' must not be empty";
        assert (options != null && options.size() == 1) : "Parameter 'options' of method 'getArchitectureFileTarget' must contain 1 element";
        IStandardEnumeration value = options.get(0);
        assert (value != null && value instanceof FileTargetValue) : "Unexpected class in method 'getArchitectureFileTarget': " + String.valueOf(value);
        FileTargetValue fileTargetValue = (FileTargetValue)value;
        List<FileTarget> fileTargets = ArchitectureFileViewShowInViewSupport.getArchitectureFileTargets(elements);
        assert (fileTargets != null && !fileTargets.isEmpty()) : "'fileTargets' of method 'getArchitectureFileTarget' must not be empty";
        switch (fileTargetValue) {
            case ARCHITECTURE_FILE: 
            case ARTEFACT: {
                return fileTargets.get(0);
            }
            case ARTEFACT_REQUIRED: 
            case ARTEFACT_APPLIED: 
            case ARTEFACT_STRICT_REQUIRED: 
            case ARTEFACT_STRICT_APPLIED: 
            case ARTEFACT_RELAXED_REQUIRED: 
            case ARTEFACT_RELAXED_APPLIED: 
            case ARTEFACT_UNRESTRICTED_REQUIRED: 
            case ARTEFACT_UNRESTRICTED_APPLIED: {
                assert (fileTargets.size() == 2) : "Missing file target entry: " + String.valueOf(fileTargets);
                return fileTargets.get(1);
            }
        }
        assert (false) : "Unhandled 'fileTargetValue': " + String.valueOf((Object)fileTargetValue);
        return null;
    }

    public static enum FileOption implements IAdditionalShowInViewOption
    {
        FILE_TARGET;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    public static final class FileTarget {
        private final FileTargetValue m_fileTargetValue;
        private final ArchitectureFile m_filePath;
        private final int m_lineNumber;

        FileTarget(FileTargetValue fileTargetValue, ArchitectureFile filePath, int lineNumber) {
            assert (fileTargetValue != null) : "Parameter 'fileTargetValue' of method 'FileTarget' must not be null";
            assert (filePath != null) : "Parameter 'filePath' of method 'FileTarget' must not be null";
            this.m_fileTargetValue = fileTargetValue;
            this.m_filePath = filePath;
            this.m_lineNumber = lineNumber;
        }

        public FileTargetValue getFileTargetValue() {
            return this.m_fileTargetValue;
        }

        public ArchitectureFile getFilePath() {
            return this.m_filePath;
        }

        public int getLineNumber() {
            return this.m_lineNumber;
        }
    }

    public static final class FileTargetValue
    extends Enum<FileTargetValue>
    implements IStandardEnumeration {
        public static final /* enum */ FileTargetValue ARCHITECTURE_FILE = new FileTargetValue("Architecture File", "ArchitectureFile");
        public static final /* enum */ FileTargetValue ARTEFACT = new FileTargetValue("Definition", "Artifact");
        public static final /* enum */ FileTargetValue ARTEFACT_REQUIRED = new FileTargetValue("Reference", "ArtifactRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_APPLIED = new FileTargetValue("Reference", "ArtifactApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_STRICT_REQUIRED = new FileTargetValue("Reference", "ArtifactStrictRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_STRICT_APPLIED = new FileTargetValue("Reference", "ArtifactStrictApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_RELAXED_REQUIRED = new FileTargetValue("Reference", "ArtifactRelaxedRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_RELAXED_APPLIED = new FileTargetValue("Reference", "ArtifactRelaxedApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_UNRESTRICTED_REQUIRED = new FileTargetValue("Reference", "ArtifactUnrestrictedRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_UNRESTRICTED_APPLIED = new FileTargetValue("Reference", "ArtifactUnrestrictedApplied");
        private final String m_presentationName;
        private final String m_imageResourceName;
        private static final /* synthetic */ FileTargetValue[] ENUM$VALUES;

        static {
            ENUM$VALUES = new FileTargetValue[]{ARCHITECTURE_FILE, ARTEFACT, ARTEFACT_REQUIRED, ARTEFACT_APPLIED, ARTEFACT_STRICT_REQUIRED, ARTEFACT_STRICT_APPLIED, ARTEFACT_RELAXED_REQUIRED, ARTEFACT_RELAXED_APPLIED, ARTEFACT_UNRESTRICTED_REQUIRED, ARTEFACT_UNRESTRICTED_APPLIED};
        }

        private FileTargetValue(String presentationName, String imageResourceName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'FileTargetValue' must not be empty";
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'FileTargetValue' must not be empty";
            this.m_presentationName = presentationName;
            this.m_imageResourceName = imageResourceName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getImageResourceName() {
            return this.m_imageResourceName;
        }

        public static FileTargetValue[] values() {
            FileTargetValue[] fileTargetValueArray = ENUM$VALUES;
            int n = fileTargetValueArray.length;
            FileTargetValue[] fileTargetValueArray2 = new FileTargetValue[n];
            System.arraycopy(ENUM$VALUES, 0, fileTargetValueArray2, 0, n);
            return fileTargetValueArray2;
        }

        public static FileTargetValue valueOf(String string) {
            return Enum.valueOf(FileTargetValue.class, string);
        }
    }
}

