/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.textsearch;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.IndexTextSearchData;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.TextSearchData;
import java.util.List;
import java.util.regex.Matcher;

public abstract class IndexBasedTextSearchHandler<T>
extends BaseTextSearchHandler {
    public IndexBasedTextSearchHandler(String connectedTo) {
        super(connectedTo);
    }

    @Override
    public final boolean supportsReplace() {
        return false;
    }

    @Override
    public boolean isReplacePossible(TextSearchData textSearchData) {
        return false;
    }

    @Override
    public final boolean isTextSearchDataCompatible(TextSearchData textSearchData) {
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'isTextSearchDataCompatible' must not be null";
        return textSearchData instanceof IndexTextSearchData;
    }

    @Override
    protected final void onCheckWholeWordClicked(TextSearchData textSearchData) {
    }

    @Override
    protected final void onCheckCaseSensitiveClicked(TextSearchData textSearchData) {
    }

    @Override
    protected void onCheckRegularExpressionClicked(TextSearchData textSearchData) {
    }

    @Override
    protected final void onButtonReplaceAllClicked(TextSearchData textSearchData) {
        assert (false) : "Not supported";
    }

    @Override
    protected final void onButtonReplaceClicked(TextSearchData textSearchData) {
        assert (false) : "Not supported";
    }

    @Override
    protected final void onButtonReplaceFindClicked(TextSearchData textSearchData) {
        assert (false) : "Not supported";
    }

    @Override
    protected final void onButtonFindClicked(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof IndexTextSearchData) : "Unexpected class in method 'onButtonFindClicked': " + String.valueOf(textSearchData);
        IndexTextSearchData figureTextSearchData = (IndexTextSearchData)textSearchData;
        figureTextSearchData.setCurrentIndex(figureTextSearchData.getCurrentFindInfo());
        int newFindInfo = this.findText(figureTextSearchData.getSearchText(), figureTextSearchData.getCurrentFindInfo(), figureTextSearchData.isCaseSensitive(), figureTextSearchData.isWholeWord(), figureTextSearchData.isRegularExpression());
        figureTextSearchData.setCurrentIndex(newFindInfo);
        figureTextSearchData.setSelectedTextInfo(new SelectedTextInfo(figureTextSearchData.getSearchText(), figureTextSearchData.isWholeWord()));
    }

    @Override
    protected final void onRevealNextOccurrence(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof IndexTextSearchData) : "Unexpected class in method 'onRevealNextOccurrence': " + String.valueOf(textSearchData);
        IndexTextSearchData figureTextSearchData = (IndexTextSearchData)textSearchData;
        figureTextSearchData.setCurrentIndex(this.getCurrentSearchPosition());
        int newFindInfo = this.findText(figureTextSearchData.getSearchText(), figureTextSearchData.getCurrentFindInfo(), figureTextSearchData.isCaseSensitive(), figureTextSearchData.isWholeWord(), figureTextSearchData.isRegularExpression());
        figureTextSearchData.setCurrentIndex(newFindInfo);
    }

    @Override
    protected final void onConnect(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof IndexTextSearchData) : "Unexpected class in method 'onConnect': " + String.valueOf(textSearchData);
        IndexTextSearchData figureTextSearchData = (IndexTextSearchData)textSearchData;
        figureTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
        figureTextSearchData.setCurrentIndex(this.getCurrentSearchPosition());
    }

    @Override
    protected final void onReset(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof IndexTextSearchData) : "Unexpected class in method 'onReset': " + String.valueOf(textSearchData);
        IndexTextSearchData figureTextSearchData = (IndexTextSearchData)textSearchData;
        SelectedTextInfo selectedTextInfo = this.getSelectedTextInfo();
        figureTextSearchData.setSearchText(selectedTextInfo.getSelectedText());
        figureTextSearchData.setSelectedTextInfo(selectedTextInfo);
        figureTextSearchData.setCurrentIndex(this.getCurrentSearchPosition());
    }

    @Override
    protected int getCurrentSearchPosition() {
        int index = this.calculatePositionForFind();
        this.setCurrentSearchPosition(index);
        return index;
    }

    @Override
    protected abstract int calculatePositionForFind();

    @Override
    protected final TextSearchData createTextSearchData(SelectedTextInfo selectedTextInfo) {
        assert (selectedTextInfo != null) : "Parameter 'selectedTextInfo' of method 'createTextSearchData' must not be null";
        return new IndexTextSearchData(selectedTextInfo.getSelectedText(), this.getCurrentSearchPosition(), selectedTextInfo);
    }

    @Override
    protected final SelectedTextInfo getSelectedTextInfo() {
        return new SelectedTextInfo("", false);
    }

    @Override
    protected int find(int currentIndex, String searchText, boolean caseSensitive, boolean wholeWord, boolean regex) {
        assert (searchText != null && !searchText.isEmpty()) : "Parameter 'searchText' of method 'find' must not be empty";
        List<T> elementsForSearch = this.getSortedElementsForSearch();
        assert (elementsForSearch != null) : "'elementsForSearch' of method 'find' must not be null";
        if (elementsForSearch.isEmpty()) {
            return 0;
        }
        T elementForTextSearch = elementsForSearch.get(currentIndex);
        String content = this.getTextForTextSearch(elementForTextSearch);
        Matcher matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regex);
        Pair<Integer, Boolean> findResult = new Pair<Integer, Boolean>((Object)currentIndex, (Object)false);
        int infoForSearch = currentIndex;
        boolean allInputSearched = false;
        while (!((Boolean)findResult.getSecond()).booleanValue()) {
            findResult = this.find(elementsForSearch, infoForSearch, content, searchText, matcher, true);
            if (!allInputSearched && !((Boolean)findResult.getSecond()).booleanValue() && (Integer)findResult.getFirst() == currentIndex) {
                allInputSearched = true;
            }
            if (allInputSearched) break;
            if (((Boolean)findResult.getSecond()).booleanValue()) continue;
            infoForSearch = (Integer)findResult.getFirst();
            T next = elementsForSearch.get(infoForSearch);
            content = this.getTextForTextSearch(next);
            matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regex);
        }
        return (Integer)findResult.getFirst();
    }

    private final Pair<Integer, Boolean> find(List<T> nodes, int currentIndex, String content, String searchText, Matcher matcher, boolean setSelection) {
        assert (nodes != null) : "Parameter 'nodes' of method 'find' must not be null";
        assert (content != null) : "Parameter 'content' of method 'find' must not be null";
        assert (searchText != null) : "Parameter 'searchText' of method 'find' must not be null";
        assert (matcher != null) : "Parameter 'matcher' of method 'find' must not be null";
        int itemsLength = nodes.size();
        assert (currentIndex >= 0 && currentIndex < itemsLength) : "";
        if (matcher.find(0)) {
            if (setSelection) {
                T nodeForSelect = nodes.get(currentIndex);
                this.selectAndRevealForFind(nodeForSelect);
            }
            currentIndex = currentIndex == itemsLength - 1 ? 0 : ++currentIndex;
            return new Pair((Object)currentIndex, (Object)true);
        }
        if (currentIndex == itemsLength - 1) {
            return new Pair((Object)0, (Object)false);
        }
        return new Pair((Object)(currentIndex + 1), (Object)false);
    }

    protected abstract String getTextForTextSearch(T var1);

    protected abstract List<T> getSortedElementsForSearch();

    protected abstract void selectAndRevealForFind(T var1);
}

