/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.AnchorListener;
import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.ConnectionAnchor;
import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.DelegatingLayout;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionAnchor;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawInteractiveFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import org.eclipse.swt.graphics.Color;

public abstract class DrawConnectionFigure<C>
extends DrawInteractiveFigure
implements Connection,
AnchorListener {
    private final C m_connection;
    private final PointList m_pointList = new PointList();
    private IConnectionFigureProvider<C> m_provider;
    private DrawConnectionAnchor<?> m_sourceAnchor;
    private DrawConnectionAnchor<?> m_targetAnchor;
    private ConnectionRouter m_connectionRouter;

    protected DrawConnectionFigure(C connection) {
        assert (connection != null) : "Parameter 'connection' of method 'DrawConnectionFigure' must not be null";
        this.m_connection = connection;
    }

    protected final void initialize(IConnectionFigureProvider<C> provider, DrawConnectionAnchor<?> source, DrawConnectionAnchor<?> target, ConnectionRouter connectionRouter) {
        assert (this.m_provider == null) : "'m_provider' of method 'initialize' must be null";
        assert (provider != null) : "Parameter 'provider' of method 'initialize' must not be null";
        assert (source != null) : "Parameter 'source' of method 'initialize' must not be null";
        assert (target != null) : "Parameter 'target' of method 'initialize' must not be null";
        assert (source != target) : "Self references to supported";
        assert (connectionRouter != null) : "Parameter 'connectionRouter' of method 'initialize' must not be null";
        this.m_provider = provider;
        this.m_sourceAnchor = source;
        this.m_targetAnchor = target;
        this.m_connectionRouter = connectionRouter;
        this.setLayoutManager(new DelegatingLayout());
        this.addMouseListener(this);
    }

    public final IConnectionFigureProvider<C> getProvider() {
        return this.m_provider;
    }

    public final C getConnection() {
        return this.m_connection;
    }

    @Override
    public final PointList getPoints() {
        return this.m_pointList;
    }

    @Override
    public final void setConnectionRouter(ConnectionRouter connectionRouter) {
        assert (connectionRouter != null) : "Parameter 'connectionRouter' of method 'setConnectionRouter' must not be null";
        this.m_connectionRouter = connectionRouter;
    }

    @Override
    public final ConnectionRouter getConnectionRouter() {
        return this.m_connectionRouter;
    }

    @Override
    public final void setRoutingConstraint(Object constraint) {
        this.m_connectionRouter.setConstraint(this, constraint);
    }

    @Override
    public final Object getRoutingConstraint() {
        return this.m_connectionRouter.getConstraint(this);
    }

    @Override
    public final void setSourceAnchor(ConnectionAnchor anchor) {
        assert (false) : "Method 'setSourceAnchor' must not be used";
    }

    @Override
    public final void setTargetAnchor(ConnectionAnchor anchor) {
        assert (false) : "Method 'setTargetAnchor' must not be used";
    }

    @Override
    public DrawConnectionAnchor<?> getSourceAnchor() {
        return this.m_sourceAnchor;
    }

    @Override
    public DrawConnectionAnchor<?> getTargetAnchor() {
        return this.m_targetAnchor;
    }

    @Override
    public final void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this.m_sourceAnchor.addAnchorListener(this);
        this.m_targetAnchor.addAnchorListener(this);
    }

    @Override
    public final void removeNotify() {
        this.m_sourceAnchor.removeAnchorListener(this);
        this.m_targetAnchor.removeAnchorListener(this);
        this.m_connectionRouter.remove(this);
        super.removeNotify();
    }

    @Override
    public final void revalidate() {
        super.revalidate();
        this.m_connectionRouter.invalidate(this);
    }

    @Override
    public final void layout() {
        this.m_connectionRouter.route(this);
        Rectangle oldBounds = this.bounds;
        super.layout();
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent(oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    @Override
    protected void mouseDownStarted(Figure source, DrawModifier modifier) {
        assert (source != null) : "Parameter 'source' of method 'mouseDownStarted' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownStarted' must not be null";
        this.m_provider.clicked(this, modifier);
    }

    @Override
    protected void mouseDownFinished(Figure source, Point location, DrawModifier modifier) {
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownFinished' must not be null";
        this.m_provider.clickFinished(this, modifier);
    }

    protected void performPaintFigure(Graphics graphics, C connection) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (connection != null) : "Parameter 'connection' of method 'performPaintFigure' must not be null";
    }

    @Override
    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialFgColor = graphics.getForegroundColor();
        Color initialBgColor = graphics.getBackgroundColor();
        int initialLineWidth = graphics.getLineWidth();
        int initialLineStyle = graphics.getLineStyle();
        int initialAntialias = graphics.getAntialias();
        int initialAlpha = graphics.getAlpha();
        graphics.setAntialias(1);
        this.performPaintFigure(graphics, this.m_connection);
        graphics.setForegroundColor(initialFgColor);
        graphics.setBackgroundColor(initialBgColor);
        graphics.setLineWidth(initialLineWidth);
        graphics.setLineStyle(initialLineStyle);
        graphics.setAntialias(initialAntialias);
        graphics.setAlpha(initialAlpha);
    }

    protected boolean performUpdate(C connection) {
        assert (connection != null) : "Parameter 'connection' of method 'performUpdate' must not be null";
        return false;
    }

    @Override
    public final boolean update() {
        this.m_provider.aboutToUpdate(this);
        if (this.performUpdate(this.m_connection)) {
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.m_connection.toString();
    }

    public static interface IConnectionFigureProvider<C>
    extends DrawInteractiveFigure.IInteractiveFigureProvider {
        default public void clicked(DrawConnectionFigure<C> connectionFigure, DrawModifier modifier) {
        }

        default public void clickFinished(DrawConnectionFigure<C> connectionFigure, DrawModifier modifier) {
        }

        default public void aboutToUpdate(DrawConnectionFigure<C> connectionFigure) {
        }
    }
}

