/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public final class WildcardContentProposalProvider
implements IContentProposalProvider {
    private String[] m_proposals;
    private final Set<WildcardPosition> m_wildcardPositions;

    public WildcardContentProposalProvider(String[] proposals, Set<WildcardPosition> wildcardPositions) {
        assert (proposals != null) : "Parameter 'proposals' of method 'WildcardContentProposalProvider' must not be null";
        assert (wildcardPositions != null) : "Parameter 'wildcardPositions' of method 'WildcardContentProposalProvider' must not be null";
        this.m_proposals = proposals;
        this.m_wildcardPositions = wildcardPositions;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        assert (contents != null) : "Parameter 'contents' of method 'getProposals' must not be null";
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        String corrected1 = contents.trim().replace(".", "\\.");
        String corrected2 = corrected1.replace("*", ".*");
        StringBuilder expression = new StringBuilder();
        if (this.m_wildcardPositions.contains((Object)WildcardPosition.START)) {
            expression.append(".*");
        }
        expression.append(corrected2);
        if (this.m_wildcardPositions.contains((Object)WildcardPosition.END)) {
            expression.append(".*");
        }
        CustomPattern pattern = CustomPattern.compileRegexPattern((String)expression.toString(), (boolean)true);
        int i = 0;
        while (i < this.m_proposals.length) {
            if (pattern.matches((CharSequence)this.m_proposals[i])) {
                list.add(new ContentProposal(this.m_proposals[i]));
            }
            ++i;
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    public void setProposals(String[] proposals) {
        assert (proposals != null) : "Parameter 'proposals' of method 'setProposals' must not be null";
        this.m_proposals = proposals;
    }

    public static enum WildcardPosition {
        START,
        END;

    }
}

