/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingWidget;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ValidatingPathWidget
extends ValidatingWidget {
    private final IConsumer m_consumer;
    private final IPathValidator m_validator;
    private final TFile m_originalInput;
    private TFile m_currentFile;
    private TFile m_basePath;
    private boolean m_resolveAgainstBasePath = true;
    private TFile m_defaultDirectory = null;
    private Text m_fileField;
    private ModifyListener m_fileFieldModifiedListener;
    private Button m_browseButton;
    private String[] m_filterExtensions;
    private SelectionAdapter m_browseSelectionListener;
    private boolean m_isFileFieldEditable;

    private ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile originalInput) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ValidatingPathWidget' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ValidatingPathWidget' must not be null";
        assert (validator != null) : "Parameter 'validator' of method 'ValidatingPathWidget' must not be null";
        this.m_consumer = consumer;
        this.m_validator = validator;
        this.m_originalInput = originalInput;
        this.m_currentFile = originalInput;
        GridLayout layout = new GridLayout(spacing > 0 ? 2 : 1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = spacing;
        this.setLayout((Layout)layout);
    }

    private void addBrowseButton() {
        this.m_browseButton = new Button((Composite)this, 0x800000);
        String browseImage = null;
        switch (this.m_validator.getType()) {
            case ARCHIVE_OR_DIRECTORY: {
                browseImage = "ArchiveOrDirectoryPath";
                break;
            }
            case DIRECTORY: {
                browseImage = "DirectoryPath";
                break;
            }
            case FILE: {
                browseImage = "FilePath";
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf(this.m_validator.getType());
                break;
            }
        }
        this.m_browseButton.setImage(UiResourceManager.getInstance().getImage(browseImage));
        this.m_browseButton.setToolTipText("Browse");
        GridData browseButtonLayoutData = new GridData(4, 0x1000000, false, false);
        this.m_browseButton.setLayoutData((Object)browseButtonLayoutData);
        this.m_browseSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = null;
                if (ValidatingPathWidget.this.m_validator.getType() == IPathValidator.PathType.FILE) {
                    FileDialog fileDialog = new FileDialog(ValidatingPathWidget.this.getShell(), 4096);
                    if (ValidatingPathWidget.this.m_defaultDirectory != null) {
                        fileDialog.setFilterPath(ValidatingPathWidget.this.m_defaultDirectory.getAbsolutePath());
                    } else if (ValidatingPathWidget.this.m_currentFile != null) {
                        TFile parentFile = ValidatingPathWidget.this.m_currentFile.getParentFile();
                        fileDialog.setFilterPath(parentFile != null ? parentFile.getAbsolutePath() : "");
                    } else if (ValidatingPathWidget.this.m_basePath != null) {
                        fileDialog.setFilterPath(ValidatingPathWidget.this.m_basePath.getAbsolutePath());
                    }
                    if (ValidatingPathWidget.this.m_filterExtensions != null && ValidatingPathWidget.this.m_filterExtensions.length > 0) {
                        fileDialog.setFilterExtensions(ValidatingPathWidget.this.m_filterExtensions);
                    }
                    path = fileDialog.open();
                } else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(ValidatingPathWidget.this.getShell(), 0);
                    if (ValidatingPathWidget.this.m_currentFile != null) {
                        directoryDialog.setFilterPath(ValidatingPathWidget.this.m_currentFile.getAbsolutePath());
                    } else if (ValidatingPathWidget.this.m_defaultDirectory != null) {
                        directoryDialog.setFilterPath(ValidatingPathWidget.this.m_defaultDirectory.getAbsolutePath());
                    } else if (ValidatingPathWidget.this.m_basePath != null) {
                        directoryDialog.setFilterPath(ValidatingPathWidget.this.m_basePath.getAbsolutePath());
                    }
                    path = directoryDialog.open();
                }
                if (path != null && path.length() > 0) {
                    ValidatingPathWidget.this.validate(path, true, true);
                }
            }
        };
        this.m_browseButton.addSelectionListener((SelectionListener)this.m_browseSelectionListener);
    }

    private void addPathField(TFile initialPath, boolean editable, boolean validate) {
        this.m_isFileFieldEditable = editable;
        this.m_fileField = new Text((Composite)this, 2048);
        this.m_fileField.setEditable(editable);
        this.m_fileField.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        GridData fileFieldLayoutData = new GridData(4, 0x1000000, true, false);
        this.m_fileField.setLayoutData((Object)fileFieldLayoutData);
        if (initialPath != null) {
            this.m_fileField.setText(this.m_basePath != null ? FileUtility.calculateRelativePath((TFile)initialPath, (TFile)this.m_basePath) : initialPath.getAbsolutePath());
        }
        if (validate) {
            this.validate(initialPath, null, false);
        }
        this.m_fileFieldModifiedListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValidatingPathWidget.this.validate(ValidatingPathWidget.this.m_fileField.getText(), false, true);
            }
        };
        this.m_fileField.addModifyListener(this.m_fileFieldModifiedListener);
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator) {
        this(parent, consumer, validator, 0, null);
        this.addBrowseButton();
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, TFile currentInput) {
        this(parent, consumer, validator, 0, currentInput);
        this.addBrowseButton();
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable) {
        this(parent, consumer, validator, spacing, currentInput, pathFieldEditable, true);
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable, boolean validate) {
        this(parent, consumer, validator, spacing, currentInput);
        assert (spacing > 0) : "'spacing' must be greater than 0";
        this.addPathField(currentInput, pathFieldEditable, validate);
        this.addBrowseButton();
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable, TFile basePath) {
        this(parent, consumer, validator, spacing, currentInput);
        this.m_basePath = basePath;
        this.addPathField(currentInput, pathFieldEditable, true);
        this.addBrowseButton();
    }

    public ValidatingPathWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable, TFile basePath, boolean resolveAgainstBasePath, TFile defaultDirectory) {
        this(parent, consumer, validator, spacing, currentInput);
        this.m_basePath = basePath;
        this.m_resolveAgainstBasePath = resolveAgainstBasePath;
        this.m_defaultDirectory = defaultDirectory;
        this.addPathField(currentInput, pathFieldEditable, true);
        this.addBrowseButton();
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.m_filterExtensions = filterExtensions;
    }

    public Button getBrowseButton() {
        return this.m_browseButton;
    }

    private void validate(String path, boolean updateFileField, boolean notifyConsumer) {
        assert (path != null) : "Parameter 'path' of method 'validate' must not be null";
        String normalizedPath = path.trim();
        if (normalizedPath.length() > 0 && FileUtility.isAbsolutePath((String)path) && this.m_basePath != null) {
            normalizedPath = FileUtility.calculateRelativePath((TFile)new TFile(normalizedPath), (TFile)this.m_basePath);
        }
        TFile newPath = null;
        if (normalizedPath.length() != 0) {
            newPath = this.m_basePath == null || FileUtility.isAbsolutePath((String)normalizedPath) ? new TFile(normalizedPath).getNormalizedAbsoluteFile() : new TFile((File)this.m_basePath, normalizedPath).getNormalizedAbsoluteFile();
        }
        this.validate(newPath, updateFileField ? normalizedPath : null, notifyConsumer);
    }

    public void setModifiable(boolean isModifiable) {
        if (isModifiable) {
            this.m_browseButton.setEnabled(true);
            this.m_fileField.setEditable(this.m_isFileFieldEditable);
        } else {
            this.m_browseButton.setEnabled(false);
            this.m_fileField.setEditable(false);
        }
    }

    private void validate(TFile file, String fileFieldText, boolean notifyConsumer) {
        this.m_currentFile = file;
        if (this.m_fileField != null && !this.m_fileField.isDisposed() && fileFieldText != null) {
            this.m_fileField.removeModifyListener(this.m_fileFieldModifiedListener);
            if (this.m_resolveAgainstBasePath && file != null) {
                this.m_fileField.setText(FileUtility.calculateRelativePath((TFile)file, (TFile)this.m_basePath));
            } else {
                this.m_fileField.setText(fileFieldText);
            }
            this.m_fileField.addModifyListener(this.m_fileFieldModifiedListener);
        }
        ValidationResult result = this.m_validator.isValid(this.m_originalInput, file);
        if (this.m_fileField != null && !this.m_fileField.isDisposed()) {
            this.updateDecoration((Control)this.m_fileField, result);
        }
        if (notifyConsumer) {
            this.m_consumer.setPath((TFile)(result.isSuccess() ? file : null), result.inputModified());
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.m_fileField != null) {
            this.m_fileField.setEnabled(enabled);
        }
        this.m_browseButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void dispose() {
        this.m_fileField.removeModifyListener(this.m_fileFieldModifiedListener);
        this.m_browseButton.removeSelectionListener((SelectionListener)this.m_browseSelectionListener);
        super.dispose();
    }

    public String getText() {
        return this.m_fileField.getText();
    }

    public void setPath(String path) {
        this.validate(path, true, false);
    }

    public void validate() {
        this.validate(this.getText(), false, false);
    }

    public void validate(boolean notifyConsumer) {
        this.validate(this.getText(), false, notifyConsumer);
    }

    public void reset() {
        this.validate(this.m_originalInput, this.m_originalInput != null ? this.m_originalInput.getNormalizedAbsolutePath() : "", true);
    }

    public void setBasePath(TFile baseDir) {
        this.m_basePath = baseDir;
    }

    public void setDefaultDirectory(TFile defaultDirectory) {
        this.m_defaultDirectory = defaultDirectory;
    }

    public void clearDecoration() {
        if (this.m_fileField != null) {
            this.clearDecoration((Control)this.m_fileField);
        }
    }

    public TFile getCurrentFile() {
        return this.m_currentFile;
    }

    public static interface IConsumer {
        public void setPath(TFile var1, boolean var2);
    }
}

