/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.FreeformLayeredPane;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.ScalableFigure;
import com.hello2morrow.draw2d.ScaledGraphics;
import com.hello2morrow.draw2d.Translatable;

public class ScalableFreeformLayeredPane
extends FreeformLayeredPane
implements ScalableFigure {
    private double scale = 1.0;

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        rect.x = (int)((double)rect.x / this.scale);
        rect.y = (int)((double)rect.y / this.scale);
        return rect;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public boolean isCoordinateSystem() {
        return true;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(graphics);
        } else {
            boolean optimizeClip;
            ScaledGraphics g = new ScaledGraphics(graphics);
            boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
            if (!optimizeClip) {
                g.clipRect(this.getBounds().getCropped(this.getInsets()));
            }
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            g.dispose();
            graphics.restoreState();
        }
    }

    @Override
    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.superFireMoved();
        this.getFreeformHelper().invalidate();
        this.repaint();
    }

    @Override
    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
    }

    @Override
    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.scale);
    }

    @Override
    protected final boolean useLocalCoordinates() {
        return false;
    }
}

