/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Border;
import com.hello2morrow.draw2d.CompoundBorder;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.GroupBoxBorder;
import com.hello2morrow.draw2d.LabeledBorder;
import org.eclipse.swt.graphics.Font;

public class LabeledContainer
extends Figure {
    public LabeledContainer() {
        this(new GroupBoxBorder());
    }

    public LabeledContainer(Border border) {
        this.setBorder(border);
        this.setOpaque(true);
    }

    private static LabeledBorder findLabeledBorder(Border border) {
        if (border instanceof LabeledBorder) {
            return (LabeledBorder)border;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            LabeledBorder labeled = LabeledContainer.findLabeledBorder(cb.getInnerBorder());
            if (labeled == null) {
                labeled = LabeledContainer.findLabeledBorder(cb.getOuterBorder());
            }
            return labeled;
        }
        return null;
    }

    public String getLabel() {
        return this.getLabeledBorder().getLabel();
    }

    protected LabeledBorder getLabeledBorder() {
        return LabeledContainer.findLabeledBorder(this.getBorder());
    }

    public void setLabel(String s) {
        this.getLabeledBorder().setLabel(s);
        this.revalidate();
        this.repaint();
    }

    public void setLabelFont(Font f) {
        this.getLabeledBorder().setFont(f);
        this.revalidate();
        this.repaint();
    }
}

