/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.PrecisionRectangle;
import com.hello2morrow.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GhostImageFigure
extends Figure {
    private int alpha = -1;
    private ImageData ghostImageData;

    public GhostImageFigure(IFigure source, int alpha, RGB transparency) {
        this.alpha = alpha;
        PrecisionRectangle sourceFigureRelativePrecisionBounds = new PrecisionRectangle(source.getBounds().getCopy());
        Image offscreenImage = new Image((Device)Display.getCurrent(), sourceFigureRelativePrecisionBounds.width, sourceFigureRelativePrecisionBounds.height);
        GC gc = new GC((Drawable)offscreenImage);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.translate(-sourceFigureRelativePrecisionBounds.x, -sourceFigureRelativePrecisionBounds.y);
        source.paint(swtGraphics);
        this.ghostImageData = offscreenImage.getImageData();
        if (transparency != null) {
            this.ghostImageData.transparentPixel = this.ghostImageData.palette.getPixel(transparency);
        }
        offscreenImage.dispose();
        swtGraphics.dispose();
        gc.dispose();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        Image feedbackImage = new Image((Device)Display.getCurrent(), this.ghostImageData);
        graphics.setAlpha(this.alpha);
        graphics.setClip(this.getBounds().getCopy());
        graphics.drawImage(feedbackImage, 0, 0, this.ghostImageData.width, this.ghostImageData.height, this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        feedbackImage.dispose();
    }
}

