/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.BreakCycles;
import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.GraphVisitor;
import com.hello2morrow.draw2d.HorizontalPlacement;
import com.hello2morrow.draw2d.InitialRankSolver;
import com.hello2morrow.draw2d.LocalOptimizer;
import com.hello2morrow.draw2d.MinCross;
import com.hello2morrow.draw2d.PopulateRanks;
import com.hello2morrow.draw2d.RankAssignmentSolver;
import com.hello2morrow.draw2d.RouteEdges;
import com.hello2morrow.draw2d.TightSpanningTreeSolver;
import com.hello2morrow.draw2d.TransposeMetrics;
import com.hello2morrow.draw2d.VerticalPlacement;
import java.util.ArrayList;
import java.util.List;

public class DirectedGraphLayout {
    List steps = new ArrayList();

    public DirectedGraphLayout() {
        this.init();
    }

    void init() {
        this.steps.add(new TransposeMetrics());
        this.steps.add(new BreakCycles());
        this.steps.add(new RouteEdges());
        this.steps.add(new InitialRankSolver());
        this.steps.add(new TightSpanningTreeSolver());
        this.steps.add(new RankAssignmentSolver());
        this.steps.add(new PopulateRanks());
        this.steps.add(new VerticalPlacement());
        this.steps.add(new MinCross());
        this.steps.add(new LocalOptimizer());
        this.steps.add(new HorizontalPlacement());
    }

    public void visit(DirectedGraph graph) {
        GraphVisitor visitor;
        if (graph.nodes.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.steps.size()) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.visit(graph);
            ++i;
        }
        i = this.steps.size() - 1;
        while (i >= 0) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.revisit(graph);
            --i;
        }
    }
}

