/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractRouter;
import com.hello2morrow.draw2d.Bendpoint;
import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.PrecisionPoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BendpointConnectionRouter
extends AbstractRouter {
    private Map constraints = new HashMap(11);
    private static final PrecisionPoint A_POINT = new PrecisionPoint();

    @Override
    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    @Override
    public void remove(Connection connection) {
        this.constraints.remove(connection);
    }

    @Override
    public void route(Connection conn) {
        Point ref2;
        Point ref1;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        List bendpoints = (List)this.getConstraint(conn);
        if (bendpoints == null) {
            bendpoints = Collections.EMPTY_LIST;
        }
        if (bendpoints.isEmpty()) {
            ref1 = conn.getTargetAnchor().getReferencePoint();
            ref2 = conn.getSourceAnchor().getReferencePoint();
        } else {
            ref1 = new Point(((Bendpoint)bendpoints.get(0)).getLocation());
            conn.translateToAbsolute(ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation());
            conn.translateToAbsolute(ref2);
        }
        A_POINT.setLocation(conn.getSourceAnchor().getLocation(ref1));
        conn.translateToRelative(A_POINT);
        points.addPoint(A_POINT);
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        A_POINT.setLocation(conn.getTargetAnchor().getLocation(ref2));
        conn.translateToRelative(A_POINT);
        points.addPoint(A_POINT);
        conn.setPoints(points);
    }

    @Override
    public void setConstraint(Connection connection, Object constraint) {
        this.constraints.put(connection, constraint);
    }
}

