/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.FigureListener;
import com.hello2morrow.draw2d.FigureUtilities;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

final class GraphViewNodeConnectionFigureWeightDecorator
extends Figure
implements FigureListener {
    private static final int FONT_HEIGHT = 9;
    private static final UiResourceManager.FontId FONT_ID = new UiResourceManager.FontId("Arial", 9, 0);
    private String m_weight;
    private Dimension m_dimension;

    private static Rectangle calculateBounds(GraphViewNodeConnectionFigure nodeConnectionFigure, Dimension dimension) {
        assert (nodeConnectionFigure != null) : "Parameter 'nodeConnectionFigure' of method 'calculateBounds' must not be null";
        assert (dimension != null) : "Parameter 'dimension' of method 'calculateBounds' must not be null";
        Rectangle bounds = new Rectangle();
        bounds.setSize(dimension);
        Point location = nodeConnectionFigure.getBounds().getCenter();
        location.x -= dimension.width / 2;
        location.y -= dimension.height / 2;
        bounds.setLocation(location);
        return bounds;
    }

    GraphViewNodeConnectionFigureWeightDecorator(GraphViewNodeConnectionFigure nodeConnectionFigure) {
        assert (nodeConnectionFigure != null) : "Parameter 'nodeConnectionFigure' of method 'GraphViewNodeConnectionFigureWeightDecorator' must not be null";
        this.setFont(UiResourceManager.getInstance().getFont(FONT_ID));
        this.update(nodeConnectionFigure);
        nodeConnectionFigure.addFigureListener(this);
    }

    void update(GraphViewNodeConnectionFigure nodeConnectionFigure) {
        assert (nodeConnectionFigure != null) : "Parameter 'nodeConnectionFigure' of method 'update' must not be null";
        String weight = Integer.toString(((GraphViewNode.GraphViewDependency)nodeConnectionFigure.getConnection()).getNumberOfParserDependencies());
        if (this.m_weight == null || !weight.equals(this.m_weight)) {
            this.m_weight = weight;
            this.m_dimension = FigureUtilities.getStringExtents(this.m_weight, this.getFont());
            this.m_dimension.width += 2;
            this.setBounds(GraphViewNodeConnectionFigureWeightDecorator.calculateBounds(nodeConnectionFigure, this.m_dimension));
        }
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialFgColor = graphics.getForegroundColor();
        Font initialFont = graphics.getFont();
        graphics.setForegroundColor(UiResourceManager.getInstance().getForegroundColor());
        graphics.setFont(this.getFont());
        graphics.drawText(this.m_weight, this.getBounds().getLocation());
        graphics.setForegroundColor(initialFgColor);
        graphics.setFont(initialFont);
    }

    @Override
    public void figureMoved(IFigure source) {
        assert (source != null && source instanceof GraphViewNodeConnectionFigure) : "Unexpected class in method 'figureMoved': " + String.valueOf(source);
        this.setBounds(GraphViewNodeConnectionFigureWeightDecorator.calculateBounds((GraphViewNodeConnectionFigure)source, this.m_dimension));
    }
}

