/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.ChopboxAnchor;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableEdge;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.graph.GeometryUtility;
import org.eclipse.swt.graphics.Color;

final class LoopEdgeFigure<T extends IDrawableNode>
extends DrawableEdge<T> {
    LoopEdgeFigure(IDrawableFigure.IDrawableFigureListener listener, RepresentationEdge<? extends RepresentationNode> edge, T from, T to, boolean architectureEnabled) {
        super(listener, edge, new ChopboxAnchor((IFigure)from), new ChopboxAnchor((IFigure)to), true, architectureEnabled);
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        if (this.shouldHideOnPaintViolationsOnly() || this.hideSelfArcs()) {
            this.setVisible(false);
            return;
        }
        Rectangle boundingBox = this.getBounds();
        graphics.setAntialias(1);
        Color color = this.isSelected() || this.isHighlighted() ? (this.paintViolationsOnly() ? UiResourceManager.getInstance().getViolatingConnectionColor() : this.getActiveLineColor()) : this.getInactiveLineColor();
        graphics.setLineWidth(this.computeLineWidth());
        graphics.setForegroundColor(color);
        this.getDecoration().setForegroundColor(color);
        Rectangle selfArc = this.getPaintAreaForSelfArc(boundingBox);
        graphics.drawArc(selfArc, 320, 290);
        super.paintFigure(graphics);
    }

    private Rectangle getPaintAreaForSelfArc(Rectangle boundingBox) {
        assert (boundingBox != null) : "Parameter 'boundingBox' of method 'getPaintAreaForSelfArc' must not be null";
        Rectangle paintArea = Rectangle.SINGLETON;
        paintArea.x = boundingBox.x + this.computeLineWidth();
        paintArea.y = boundingBox.y + this.computeLineWidth();
        paintArea.width = boundingBox.width - 2 * this.computeLineWidth();
        paintArea.height = boundingBox.height - 2 * this.computeLineWidth();
        return paintArea;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        int toleranceBySide = this.computeLineWidth() > 1 ? this.computeLineWidth() / 2 : 2;
        return GeometryUtility.ellipseContainsPoint(this.getPaintAreaForSelfArc(this.getBounds()), x, y, toleranceBySide);
    }

    @Override
    public void setPoints(PointList list) {
        assert (list != null) : "Parameter 'list' of method 'setPoints' must not be null";
        assert (list.size() == 2) : "Two points expected in 'setPoints'";
        Point first = list.getFirstPoint().getCopy();
        Point last = list.getLastPoint().getCopy();
        Rectangle boundingBox = Rectangle.SINGLETON;
        this.getPointList().removeAllPoints();
        Object from = this.getFrom();
        boundingBox.x = from.getBounds().x + from.getBounds().width / 2 - 17;
        boundingBox.y = from.getBounds().y - from.getBounds().height - 10;
        boundingBox.width = 35;
        boundingBox.height = 35;
        first = new Point(boundingBox.x + boundingBox.width - this.computeLineWidth() - 3, boundingBox.y + boundingBox.height - 10);
        last = new Point(first.x - 10, first.y + 10);
        this.getPointList().addPoint(first);
        this.getPointList().addPoint(last);
        this.setBounds(boundingBox);
        this.firePropertyChange("points", null, this.getPointList());
        this.repaint();
    }
}

