/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardMessageDialog;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class OperationResultDialog
extends StandardMessageDialog {
    private final OperationResult m_result;

    public static void open(Shell parentShell, OperationResult result) {
        int imageType = 2;
        if (result.isFailure()) {
            imageType = 1;
        } else if (result.containsWarning()) {
            imageType = 4;
        }
        OperationResultDialog.open(parentShell, result.getDescription(), imageType, result);
    }

    public static void open(Shell parentShell, String dialogMessage, int dialogImageType, OperationResult result) {
        OperationResultDialog dialog = new OperationResultDialog(parentShell, dialogMessage, dialogImageType, result);
        dialog.open();
    }

    private OperationResultDialog(Shell parentShell, String dialogMessage, int dialogImageType, OperationResult result) {
        super(parentShell, dialogMessage, dialogImageType);
        assert (result != null) : "Parameter 'result' of method 'OperationResultDialog' must not be null";
        this.m_result = result;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x4F0);
    }

    @Override
    protected Point getMinimumSize() {
        return new Point(super.getMinimumSize().x, super.getMinimumSize().y + 100);
    }

    @Override
    protected Point getMaximumSize() {
        return new Point(700, 500);
    }

    protected Control createCustomArea(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createCustomArea' must not be null";
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        List messages = this.m_result.getMessages();
        TableViewer tableViewer = new TableViewer((Composite)sashForm, 772);
        OperationResultLabelProvider provider = new OperationResultLabelProvider();
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        tableViewer.setInput((Object)messages);
        final Text completeMessage = new Text((Composite)sashForm, 578);
        completeMessage.setEditable(false);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstSelected = selection.getFirstElement();
                if (firstSelected instanceof OperationResult.Message) {
                    OperationResult.Message firstSelectedMessage = (OperationResult.Message)firstSelected;
                    completeMessage.setText(firstSelectedMessage.getMessage());
                }
            }
        });
        if (!messages.isEmpty()) {
            tableViewer.setSelection((ISelection)new StructuredSelection(messages.get(messages.size() - 1)));
        }
        sashForm.setWeights(new int[]{60, 40});
        return sashForm;
    }

    private static final class OperationResultLabelProvider
    extends LabelProvider {
        private OperationResultLabelProvider() {
        }

        public String getText(Object element) {
            assert (element != null) : "Parameter 'element' of method 'getText' must not be null";
            assert (element instanceof OperationResult.Message) : "Unexpected class: " + String.valueOf(element);
            OperationResult.Message message = (OperationResult.Message)element;
            return message.getCause().getPresentationName();
        }

        public Image getImage(Object element) {
            assert (element != null) : "Parameter 'element' of method 'getImage' must not be null";
            assert (element instanceof OperationResult.Message) : "Unexpected class: " + String.valueOf(element);
            OperationResult.Message message = (OperationResult.Message)element;
            switch (message.getStatus()) {
                case ERROR: {
                    return UiResourceManager.getInstance().getImage("Error");
                }
                case INFO: {
                    return UiResourceManager.getInstance().getImage("Info");
                }
                case WARNING: {
                    return UiResourceManager.getInstance().getImage("Warning");
                }
            }
            assert (false) : "Unhandled status: " + String.valueOf(message.getStatus());
            return null;
        }
    }
}

