/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dependenciesview;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Color;

public final class LinePropertiesUtilities {
    private static final int STEP_1 = 20;
    private static final int STEP_2 = 400;
    private static final int STEP_3 = 10000;

    private LinePropertiesUtilities() {
    }

    public static int calculateLineWidth(int weight) {
        if (weight <= 20) {
            return 1;
        }
        if (weight <= 400) {
            return 2;
        }
        if (weight <= 10000) {
            return 3;
        }
        return 4;
    }

    public static int setLineAttributes(int dependencies, int violations, int violationsToBeFixed, int violationsIgnored, int deprecations, int deprecationsToBeFixed, int deprecationsIgnored, boolean highlight, Graphics graphics) {
        int lineStyle;
        Color color;
        int alpha;
        assert (graphics != null) : "Parameter 'graphics' of method 'setLineAttributes' must not be null";
        int lineWidth = LinePropertiesUtilities.calculateLineWidth(dependencies);
        if (highlight) {
            alpha = 255;
            color = violations == 0 && deprecations == 0 && violationsToBeFixed == 0 && deprecationsToBeFixed == 0 ? UiResourceManager.getInstance().getNoneViolatingConnectionColor() : (violations + violationsToBeFixed == dependencies ? UiResourceManager.getInstance().getViolatingConnectionColor() : (deprecations + deprecationsToBeFixed == dependencies ? UiResourceManager.getInstance().getDeprecatedConnectionColor() : UiResourceManager.getInstance().getMixedConnectionColor()));
            lineStyle = violationsIgnored > 0 || violationsToBeFixed > 0 || deprecationsIgnored > 0 || deprecationsToBeFixed > 0 ? 4 : 1;
        } else {
            alpha = 70;
            lineStyle = 1;
            color = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY);
        }
        graphics.setLineWidth(lineWidth);
        graphics.setAlpha(alpha);
        graphics.setLineStyle(lineStyle);
        graphics.setForegroundColor(color);
        return lineWidth;
    }
}

