/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

final class CycleGroupsViewContentProvider
extends ViewerFilter
implements ITreeContentProvider {
    private static final String CYCLE_GROUPS_VIEW_KEY = "CycleGroupsView";
    private static final String HIDE_IGNORED_KEY = "HideIgnored";
    private static final String HIDE_DUPLICATES_KEY = "HideDuplicates";
    private boolean m_hideIgnored = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", "CycleGroupsView").getBoolean("HideIgnored", true);
    private boolean m_hideDuplicates = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", "CycleGroupsView").getBoolean("HideDuplicates", true);

    CycleGroupsViewContentProvider() {
    }

    boolean getHideIgnored() {
        return this.m_hideIgnored;
    }

    boolean setHideIgnored(boolean hide) {
        if (this.m_hideIgnored != hide) {
            this.m_hideIgnored = hide;
            IEclipsePreferences preferences = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", CYCLE_GROUPS_VIEW_KEY);
            preferences.putBoolean(HIDE_IGNORED_KEY, this.m_hideIgnored);
            PreferencesUtility.save(preferences);
            return true;
        }
        return false;
    }

    boolean getHideDuplicates() {
        return this.m_hideDuplicates;
    }

    boolean setHideDuplicates(boolean hide) {
        if (this.m_hideDuplicates != hide) {
            this.m_hideDuplicates = hide;
            IEclipsePreferences preferences = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", CYCLE_GROUPS_VIEW_KEY);
            preferences.putBoolean(HIDE_DUPLICATES_KEY, this.m_hideDuplicates);
            PreferencesUtility.save(preferences);
            return true;
        }
        return false;
    }

    private boolean isIgnored(AnalyzerCycleGroup cycleGroup) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'isIgnored' must not be null";
        Issue associatedIssue = cycleGroup.getAssociatedIssue();
        return associatedIssue != null && associatedIssue.getResolution() != null && associatedIssue.getResolution().ignores();
    }

    private boolean isDuplicate(AnalyzerCycleGroup cycleGroup) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'isDuplicate' must not be null";
        return cycleGroup.isDuplicate();
    }

    boolean matchFilter(Collection<AnalyzerCycleGroup> cycleGroups) {
        assert (cycleGroups != null && !cycleGroups.isEmpty()) : "Parameter 'cycleGroups' of method 'matchFilter' must not be empty";
        if (!this.m_hideIgnored && !this.m_hideDuplicates) {
            return false;
        }
        boolean showIgnored = false;
        boolean showDuplicates = false;
        for (AnalyzerCycleGroup nextCycleGroup : cycleGroups) {
            if (this.isIgnored(nextCycleGroup)) {
                showIgnored = true;
            }
            if (this.isDuplicate(nextCycleGroup)) {
                showDuplicates = true;
            }
            if (showIgnored && showDuplicates) break;
        }
        if (showIgnored) {
            this.m_hideIgnored = false;
        }
        if (showDuplicates) {
            this.m_hideDuplicates = false;
        }
        return true;
    }

    boolean include(AnalyzerCycleGroup cycleGroup) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'include' must not be null";
        if (this.m_hideIgnored && this.isIgnored(cycleGroup)) {
            return false;
        }
        return !this.m_hideDuplicates || !this.isDuplicate(cycleGroup);
    }

    int getNumberOfNotFiltered(List<AnalyzerCycleGroup> cycleGroups) {
        assert (cycleGroups != null) : "Parameter 'cycleGroups' of method 'getNumberOfNotFiltered' must not be null";
        int notFiltered = 0;
        for (AnalyzerCycleGroup nextCycleGroup : cycleGroups) {
            if (!this.include(nextCycleGroup)) continue;
            ++notFiltered;
        }
        return notFiltered;
    }

    boolean hasFiltered(Collection<AnalyzerResult> results) {
        assert (results != null) : "Parameter 'results' of method 'hasFiltered' must not be null";
        if (!results.isEmpty() && (this.m_hideDuplicates || this.m_hideIgnored)) {
            for (AnalyzerResult nextResult : results) {
                for (AnalyzerCycleGroup nextCycleGroup : nextResult.getChildren(AnalyzerCycleGroup.class)) {
                    if (this.include(nextCycleGroup)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AnalyzerCycleGroup cycleGroup;
        assert (element != null) : "Parameter 'element' of method 'select' must not be null";
        return !this.m_hideDuplicates && !this.m_hideIgnored || !(element instanceof AnalyzerCycleGroup) || this.include(cycleGroup = (AnalyzerCycleGroup)element);
    }

    public Object[] getElements(Object parent) {
        assert (parent instanceof Collection) : "Unexpected class: " + parent.getClass().getName();
        Collection analyzerResults = (Collection)parent;
        ArrayList<AnalyzerResult> elements = new ArrayList<AnalyzerResult>(analyzerResults.size());
        for (Object next : analyzerResults) {
            assert (next instanceof AnalyzerResult) : "Unexpected class in method 'getElements': " + String.valueOf(next);
            AnalyzerResult nextAnalyzerResult = (AnalyzerResult)next;
            boolean include = false;
            for (AnalyzerCycleGroup nextCycleGroup : nextAnalyzerResult.getChildren(AnalyzerCycleGroup.class)) {
                if (!this.include(nextCycleGroup)) continue;
                include = true;
                break;
            }
            if (!include) continue;
            elements.add(nextAnalyzerResult);
        }
        return elements.toArray();
    }

    public Object getParent(Object child) {
        assert (child != null) : "Parameter 'child' of method 'getParent' must not be null";
        assert (child instanceof NamedElement) : "Unexpected class: " + child.getClass().getName();
        if (child instanceof AnalyzerResult) {
            return null;
        }
        return ((NamedElement)child).getParent();
    }

    public Object[] getChildren(Object parent) {
        assert (parent != null) : "Parameter 'parent' of method 'getChildren' must not be null";
        assert (parent instanceof NamedElement) : "Unexpected class: " + parent.getClass().getName();
        if (parent instanceof AnalyzerResult) {
            return ((AnalyzerResult)parent).getChildren(AnalyzerCycleGroup.class).toArray();
        }
        assert (parent instanceof AnalyzerCycleGroup) : "Unexpected class: " + parent.getClass().getName();
        return ((NamedElement)parent).getChildren().toArray();
    }

    public boolean hasChildren(Object parent) {
        assert (parent != null) : "Parameter 'parent' of method 'hasChildren' must not be null";
        assert (parent instanceof NamedElement) : "Unexpected class: " + parent.getClass().getName();
        if (parent instanceof AnalyzerResult) {
            return ((AnalyzerResult)parent).hasChildren(false, new Class[]{AnalyzerCycleGroup.class});
        }
        return ((NamedElement)parent).hasChildren();
    }
}

