/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.swt.base.view.SingleIssueProviderComparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class CycleGroupBasedViewerComparator
extends ViewerComparator {
    private Sort m_sort = Sort.SIZE;
    private boolean m_ascending = true;

    CycleGroupBasedViewerComparator() {
    }

    public void setSort(Sort sort) {
        assert (sort != null) : "Parameter 'sort' of method 'setSort' must not be null";
        if (this.m_sort.equals((Object)sort)) {
            this.m_ascending = !this.m_ascending;
        } else {
            this.m_sort = sort;
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
        assert (o1 != null && o1 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o1);
        assert (o2 != null && o2 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o2);
        NamedElement namedElement1 = (NamedElement)o1;
        NamedElement namedElement2 = (NamedElement)o2;
        assert (namedElement1 != namedElement2) : "Same elements";
        int result = -1;
        switch (this.m_sort) {
            case NAME: {
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case SIZE: {
                if (namedElement1 instanceof AnalyzerCycleGroup && namedElement2 instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup group1 = (AnalyzerCycleGroup)namedElement1;
                    AnalyzerCycleGroup group2 = (AnalyzerCycleGroup)namedElement2;
                    result = Integer.compare(group1.getNumberOfCyclicElements(), group2.getNumberOfCyclicElements());
                    if (result != 0) break;
                    result = this.compareName((NamedElement)group1, (NamedElement)group2);
                    break;
                }
                if (!(namedElement1 instanceof AnalyzerResult) || !(namedElement2 instanceof AnalyzerResult)) break;
                AnalyzerResult analyzerResult1 = (AnalyzerResult)namedElement1;
                AnalyzerResult analyzerResult2 = (AnalyzerResult)namedElement2;
                result = Integer.compare(analyzerResult1.getChildren(AnalyzerCycleGroup.class).size(), analyzerResult2.getChildren(AnalyzerCycleGroup.class).size());
                if (result != 0) break;
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case SCOPE: {
                if (namedElement1 instanceof AnalyzerCycleGroup && namedElement2 instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup group1 = (AnalyzerCycleGroup)namedElement1;
                    AnalyzerCycleGroup group2 = (AnalyzerCycleGroup)namedElement2;
                    NamedElement scope1 = group1.getScope();
                    NamedElement scope2 = group2.getScope();
                    if (scope1 == null || scope2 == null) break;
                    result = this.compareName(scope1, scope2);
                    break;
                }
                if (!(namedElement1 instanceof AnalyzerResult) || !(namedElement2 instanceof AnalyzerResult)) break;
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case RESOLUTION_PRIORITY: {
                if (namedElement1 instanceof AnalyzerCycleGroup && namedElement2 instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup group1 = (AnalyzerCycleGroup)namedElement1;
                    AnalyzerCycleGroup group2 = (AnalyzerCycleGroup)namedElement2;
                    if (!group1.isDuplicate() && !group2.isDuplicate()) {
                        result = SingleIssueProviderComparator.compareByResolutionPriority((ISingleIssueProvider)group1, (ISingleIssueProvider)group2);
                        break;
                    }
                    result = this.compareName(namedElement1, namedElement2);
                    break;
                }
                if (!(namedElement1 instanceof AnalyzerResult) || !(namedElement2 instanceof AnalyzerResult)) break;
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case LOC: {
                if (namedElement1 instanceof AnalyzerCycleGroup && namedElement2 instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup group1 = (AnalyzerCycleGroup)namedElement1;
                    AnalyzerCycleGroup group2 = (AnalyzerCycleGroup)namedElement2;
                    result = Integer.compare(group1.getLinesOfCodeOfInvolvedSourceFiles(), group2.getLinesOfCodeOfInvolvedSourceFiles());
                    if (result != 0) break;
                    result = this.compareName((NamedElement)group1, (NamedElement)group2);
                    break;
                }
                result = 0;
                break;
            }
            default: {
                assert (false) : "Unandled sort: " + String.valueOf((Object)this.m_sort);
                break;
            }
        }
        return this.m_ascending ? result * -1 : result;
    }

    private int compareName(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'compareResults' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compareResults' must not be null";
        return element1.getPresentationName(false).compareTo(element2.getPresentationName(false));
    }

    static enum Sort {
        NAME,
        SIZE,
        SCOPE,
        RESOLUTION_PRIORITY,
        LOC;

    }
}

