/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CalculateCycleElementMetricsCommand;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleElementMetrics;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CancellableUiWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CycleElementMetricsViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleElementMetricsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public final class CycleElementMetricsView
extends WorkbenchAuxiliaryView {
    private PropertyTableViewer<CycleElementMetrics> m_metricsViewer;
    private CancellableUiWorkerContext m_currentWorkerContext;
    private CalculateCycleElementMetricsCommand m_currentCommand;
    private AnalyzerCycleGroup m_currentCycleGroup;

    @Override
    public IViewId getViewId() {
        return ViewId.CYCLE_ELEMENT_METRICS_VIEW;
    }

    @Override
    protected boolean supportsSleep() {
        return false;
    }

    @Override
    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_metricsViewer.getTable());
    }

    @Override
    public StructureMode getStructureMode() {
        return StructureMode.NON_RECURSIVE;
    }

    @Override
    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        return view.getViewId().equals(ViewId.CYCLE_VIEW) && view.isReady();
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        this.m_metricsViewer = new PropertyTableViewer<CycleElementMetrics>(viewContentArea, new CycleElementMetricsBeanAdapter(), PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_metricsViewer.addColumn("Name", "name", "name", "image", 80, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricsViewer.addColumn("Incoming", "incoming", "incomingSort", null, 30, PropertyTableViewer.ColumnType.NUMBER).getColumn().setToolTipText("Incoming dependency count for this cycle group");
        this.m_metricsViewer.addColumn("Outgoing", "outgoing", "outgoingSort", null, 30, PropertyTableViewer.ColumnType.NUMBER).getColumn().setToolTipText("Outgoing dependency count for this cycle group");
        this.m_metricsViewer.addColumn("Incoming Interface", "interfaceIncoming", "interfaceIncomingSort", null, 30, PropertyTableViewer.ColumnType.NUMBER).getColumn().setToolTipText("Incoming dependencies that could be redirected to an interface");
        this.m_metricsViewer.addColumn("Interface Score", "interfaceScore", "interfaceScoreSort", null, 30, PropertyTableViewer.ColumnType.NUMBER).getColumn().setToolTipText("Interfaceable incoming dependencies multiplied by outgoing dependencies (higher values indicate good candidates for interface substitution)");
        this.m_metricsViewer.addColumn("Coupling Score", "couplingScore", "couplingScoreSort", null, 30, PropertyTableViewer.ColumnType.NUMBER).getColumn().setToolTipText("Incoming multiplied by outgoing dependency count (higher values contribute more to overall coupling)");
    }

    private void collect(final AnalyzerCycleGroup cycleGroup) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'collect' must not be null";
        assert (this.m_currentWorkerContext == null) : "'m_currentWorkerContext' of method 'collect' must be null";
        assert (this.m_currentCommand == null) : " 'm_currentCommand' of method 'collect' must be null";
        this.m_metricsViewer.setAdditionalFirstColumnInfo("Calculating...");
        this.m_metricsViewer.showData(Collections.emptyList());
        final CalculateCycleElementMetricsCommand command = new CalculateCycleElementMetricsCommand(this.getSoftwareSystemProvider(), new CalculateCycleElementMetricsCommand.IInteraction(){

            public boolean collect(CalculateCycleElementMetricsCommand.Data data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setAnalyzerCycleGroup(cycleGroup);
                return true;
            }
        });
        assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
        this.m_currentCycleGroup = cycleGroup;
        this.m_currentCommand = command;
        this.m_currentWorkerContext = new CancellableUiWorkerContext(this.m_metricsViewer.getDisplay());
        UserInterfaceAdapter.getInstance().run((Command)command, this.m_currentWorkerContext, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (CycleElementMetricsView.this.m_currentCommand == command && CycleElementMetricsView.this.m_metricsViewer != null && !CycleElementMetricsView.this.m_metricsViewer.isDisposed()) {
                    Table table = CycleElementMetricsView.this.m_metricsViewer.getTable();
                    table.setRedraw(false);
                    boolean reset = true;
                    List metrics = CycleElementMetricsView.this.m_currentCommand.getMetrics();
                    if (exception == null && metrics != null) {
                        CycleElementMetricsView.this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
                        CycleElementMetricsView.this.m_metricsViewer.showData(metrics);
                        CycleElementMetricsView.this.setPartName("'" + cycleGroup.getName() + "' Element Metrics");
                        reset = false;
                    }
                    if (reset) {
                        CycleElementMetricsView.this.m_currentCycleGroup = null;
                        CycleElementMetricsView.this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
                        CycleElementMetricsView.this.m_metricsViewer.showData(Collections.emptyList());
                        CycleElementMetricsView.this.setTitleTooltip("No metrics available for selection");
                    }
                    table.setRedraw(true);
                    CycleElementMetricsView.this.m_currentCommand = null;
                    CycleElementMetricsView.this.m_currentWorkerContext = null;
                }
            }
        });
    }

    private void cancelCollect(boolean inDestroy) {
        this.m_currentCycleGroup = null;
        if (!inDestroy) {
            this.resetPartName();
            this.setTitleTooltip(null);
            this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
            this.m_metricsViewer.showData(null);
        }
        if (this.m_currentWorkerContext != null) {
            assert (this.m_currentCommand != null) : "'m_currentCommand' of method 'cancelCollect' must not be null";
            this.m_currentWorkerContext.cancel();
            this.m_currentWorkerContext = null;
            this.m_currentCommand = null;
        }
    }

    @Override
    protected void destroyViewContent() {
        this.cancelCollect(true);
        super.destroyViewContent();
    }

    @Override
    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null && connectedView instanceof CycleView) : "Unexpected class in method 'handleSelection': " + String.valueOf(connectedView);
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        StrictPair<AnalyzerCycleGroup, GraphViewCycleGroupNode> cycleGroupInfo = CycleElementMetricsViewShowInViewSupport.getCycleGroupInfo(elements);
        if (cycleGroupInfo != null) {
            AnalyzerCycleGroup selectedCycleGroup = (AnalyzerCycleGroup)cycleGroupInfo.getFirst();
            if (selectedCycleGroup != this.m_currentCycleGroup) {
                this.cancelCollect(false);
                this.collect((AnalyzerCycleGroup)cycleGroupInfo.getFirst());
            }
        } else {
            this.cancelCollect(false);
        }
    }

    @Override
    protected void disconnect() {
        this.cancelCollect(false);
        super.disconnect();
    }

    @Override
    public List<Element> getSelectedElements() {
        List<CycleElementMetrics> selected = this.m_metricsViewer.getSelected();
        if (selected != null && !selected.isEmpty()) {
            return selected.stream().map(c -> c.namedElement()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

