/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.common;

import com.hello2morrow.sonargraph.ui.swt.common.IViewAccesor;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewKey;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViewNavigationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewNavigationManager.class);
    private static final Integer DEFAULT_NUMBER_OF_STATES_LIMIT = 100;
    private static ViewNavigationManager s_instance = null;
    private final ArrayList<NavigationState> m_states = new ArrayList();
    private final Map<ViewKey, NavigationState> m_viewKeyToInitialState = new THashMap();
    private final Map<ViewKey, NavigationState> m_viewKeyToCurrentState = new THashMap();
    private final IViewAccesor m_accessor;
    private int m_currentIndex = -1;
    private int m_nextStateId = 0;

    private ViewNavigationManager(IViewAccesor accesor) {
        assert (accesor != null) : "Parameter 'accesor' of method 'ViewNavigationManager' must not be null";
        this.m_accessor = accesor;
    }

    public static void createInstance(IViewAccesor accesor) {
        assert (s_instance == null) : "'s_instance' of method 'createInstance' must be null";
        s_instance = new ViewNavigationManager(accesor);
    }

    public static ViewNavigationManager getInstance() {
        assert (s_instance != null) : "'s_instance' of method 'getInstance' must not be null";
        return s_instance;
    }

    public void delete() {
        assert (s_instance != null) : "Instance not created";
        s_instance = null;
    }

    public NavigationState createNavigationState(IViewId viewId, String secondaryId, NavigationState.Type type) {
        assert (viewId != null) : "Parameter 'viewId' of method 'createNavigationState' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createNavigationState' must not be null";
        return new NavigationState(new ViewKey(viewId, secondaryId), type, this.m_nextStateId++);
    }

    private boolean checkCurrentIndexIntegrity(ViewKey viewKey) {
        if (this.m_states.isEmpty()) {
            assert (this.m_currentIndex == -1) : "'m_currentIndex' must be '-1'" + (String)(viewKey != null ? " [" + String.valueOf(viewKey) + "]" : "");
            return true;
        }
        assert (this.m_currentIndex >= 0 && this.m_currentIndex < this.m_states.size()) : "'m_currentIndex' out of range" + (String)(viewKey != null ? " [" + String.valueOf(viewKey) + "]" : "");
        return false;
    }

    private void removeTrailingStates(int startIndex) {
        assert (startIndex >= 0 && startIndex < this.m_states.size()) : "'startIndex' out of range";
        if (startIndex < this.m_states.size() - 1) {
            List<NavigationState> removed = this.m_states.subList(startIndex + 1, this.m_states.size());
            this.m_accessor.navigationStatesRemoved(removed);
            removed.clear();
        }
    }

    public synchronized boolean hasNavigationState(int stateId) {
        return this.m_states.stream().anyMatch(navigationState -> navigationState.getId() == stateId);
    }

    public synchronized void changeSecondaryId(IViewId viewId, String secondaryId, String newSecondaryId) {
        NavigationState currentState;
        assert (viewId != null) : "Parameter 'viewId' of method 'changeSecondaryId' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'changeSecondaryId' must not be empty";
        assert (newSecondaryId != null && newSecondaryId.length() > 0) : "Parameter 'newSecondaryId' of method 'changeSecondaryId' must not be empty";
        assert (!secondaryId.equals(newSecondaryId)) : "Secondary ids not different";
        ViewKey viewKey = new ViewKey(viewId, secondaryId);
        ViewKey newViewKey = new ViewKey(viewId, newSecondaryId);
        for (NavigationState nextState : this.m_states) {
            if (!nextState.getViewKey().equals(viewKey)) continue;
            nextState.setViewKey(newViewKey);
        }
        NavigationState initialState = this.m_viewKeyToInitialState.remove(viewKey);
        if (initialState != null) {
            this.m_viewKeyToInitialState.put(newViewKey, initialState);
        }
        if ((currentState = this.m_viewKeyToCurrentState.remove(viewKey)) != null) {
            this.m_viewKeyToCurrentState.put(newViewKey, currentState);
        }
    }

    private StateAction determineStateAction(NavigationState first, NavigationState second) {
        ViewKey secondViewKey;
        assert (first != null) : "Parameter 'first' of method 'determineStateAction' must not be null";
        assert (second != null) : "Parameter 'second' of method 'determineStateAction' must not be null";
        assert (first != second) : "Same instances";
        ViewKey firstViewKey = first.getViewKey();
        if (firstViewKey.equals(secondViewKey = second.getViewKey())) {
            NavigationState.Type firstStateType = first.getType();
            NavigationState.Type secondStateType = second.getType();
            if (secondStateType == NavigationState.Type.VIEW_SELECTED) {
                LOGGER.debug("Discarded state '" + String.valueOf(secondViewKey) + "' [" + String.valueOf((Object)secondStateType) + "] - view already selected");
                return StateAction.DISCARD_SECOND;
            }
            if ((firstStateType == NavigationState.Type.VIEW_SELECTED || firstStateType == secondStateType) && first.equalsContent(second)) {
                LOGGER.debug("Discarded state '" + String.valueOf(secondViewKey) + "' [" + String.valueOf((Object)secondStateType) + "] - equal content");
                return StateAction.DISCARD_SECOND;
            }
            if (firstStateType == NavigationState.Type.VIEW_SELECTED && (secondStateType == NavigationState.Type.VIEW_SELECTED || secondStateType.isContentRelated()) && first.mayBeReplacedByMoreDetailedState() && second.containsAllElementsFrom(first)) {
                LOGGER.debug("Replace state '" + String.valueOf(firstViewKey) + "' [" + String.valueOf((Object)firstStateType) + "] with more detailed state '" + String.valueOf(secondViewKey) + "' [" + String.valueOf((Object)secondStateType) + "]");
                return StateAction.REPLACE_FIRST;
            }
        }
        return StateAction.ADD_SECOND;
    }

    public static int getIndexOf(List<NavigationState> states, NavigationState indexOf) {
        assert (states != null) : "Parameter 'states' of method 'getIndexOf' must not be null";
        assert (indexOf != null) : "Parameter 'indexOf' of method 'getIndexOf' must not be null";
        int i = 0;
        while (i < states.size()) {
            if (states.get(i) == indexOf) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getIndexOf(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'getIndexOf' must not be null";
        return ViewNavigationManager.getIndexOf(this.m_states, state);
    }

    public synchronized void setCurrentNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'setCurrentNavigationState' must not be null";
        ViewKey viewKey = state.getViewKey();
        LOGGER.debug("Set current navigation state for state for '" + String.valueOf(viewKey) + "'");
        int indexOf = this.getIndexOf(state);
        if (indexOf != -1) {
            if (this.m_currentIndex != indexOf) {
                this.m_currentIndex = indexOf;
            } else {
                LOGGER.debug("Ignored - is already the current navigation state.");
            }
        } else {
            LOGGER.warn("Navigation state not found in list.");
        }
        LOGGER.debug("Set current navigation state for state for '" + String.valueOf(viewKey) + "' - done");
    }

    public synchronized void addNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'addNavigationState' must not be null";
        ViewKey viewKey = state.getViewKey();
        LOGGER.debug("Add state for '" + String.valueOf(viewKey) + "'");
        if (this.m_accessor.inNavigationStateRestore()) {
            LOGGER.warn("Discarded state during navigation state restore");
            return;
        }
        if (!this.m_states.isEmpty()) {
            NavigationState currentState = this.getCurrentNavigationState();
            this.removeTrailingStates(this.m_currentIndex);
            StateAction stateAction = this.determineStateAction(currentState, state);
            switch (stateAction) {
                case DISCARD_SECOND: {
                    this.m_accessor.navigationStatesChanged();
                    LOGGER.debug("Add state for '" + String.valueOf(viewKey) + "' - done");
                    return;
                }
                case REPLACE_FIRST: {
                    NavigationState removed = this.m_states.remove(this.m_currentIndex);
                    assert (removed != null) : "'removed' of method 'addNavigationState' must not be null";
                    this.m_currentIndex = this.m_states.isEmpty() ? -1 : --this.m_currentIndex;
                    this.checkCurrentIndexIntegrity(viewKey);
                    if (removed == this.m_viewKeyToInitialState.get(viewKey)) {
                        this.m_viewKeyToInitialState.remove(viewKey);
                    }
                    if (removed == this.m_viewKeyToCurrentState.get(viewKey)) {
                        this.m_viewKeyToCurrentState.remove(viewKey);
                    }
                    this.m_accessor.navigationStatesRemoved(Collections.singletonList(removed));
                    break;
                }
                case ADD_SECOND: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled state action: " + String.valueOf((Object)stateAction);
                    break;
                }
            }
        }
        if (!this.m_viewKeyToInitialState.containsKey(viewKey)) {
            this.m_viewKeyToInitialState.put(viewKey, state);
        }
        this.m_viewKeyToCurrentState.put(viewKey, state);
        this.m_states.add(state);
        this.m_currentIndex = this.getIndexOf(state);
        assert (this.m_currentIndex != -1) : "State not found";
        this.checkCurrentIndexIntegrity(state.getViewKey());
        this.m_accessor.navigationStateAdded(state);
        if (this.m_states.size() > DEFAULT_NUMBER_OF_STATES_LIMIT) {
            NavigationState removed = this.m_states.remove(0);
            --this.m_currentIndex;
            this.checkCurrentIndexIntegrity(state.getViewKey());
            this.m_accessor.navigationStatesRemoved(Collections.singletonList(removed));
        }
        this.m_accessor.navigationStatesChanged();
        LOGGER.debug("Add state for '" + String.valueOf(viewKey) + "' - done");
    }

    public synchronized boolean hasPreviousNavigationState() {
        return this.m_currentIndex > 0;
    }

    public synchronized boolean hasNextNavigationState() {
        return this.m_currentIndex < this.m_states.size() - 1;
    }

    public synchronized void restoreNextNavigationState() {
        ++this.m_currentIndex;
        this.checkCurrentIndexIntegrity(null);
        NavigationState state = this.m_states.get(this.m_currentIndex);
        assert (state != null) : "'state' of method 'restoreNextNavigationState' must not be null";
        this.m_accessor.restoreNavigationState(state);
        this.m_viewKeyToCurrentState.put(state.getViewKey(), state);
        this.m_accessor.navigationStatesChanged();
    }

    public synchronized void restorePreviousNavigationState() {
        NavigationState currentState = this.getCurrentNavigationState();
        assert (currentState != null) : "'currentState' of method 'restorePreviousNavigationState' must not be null";
        --this.m_currentIndex;
        this.checkCurrentIndexIntegrity(currentState.getViewKey());
        NavigationState state = this.m_states.get(this.m_currentIndex);
        this.m_accessor.restoreNavigationState(state);
        this.m_viewKeyToCurrentState.put(state.getViewKey(), state);
        this.m_accessor.navigationStatesChanged();
    }

    public synchronized void restoreNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        this.m_accessor.restoreNavigationState(state);
    }

    public synchronized NavigationState getInitialViewNavigationState(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getInitialViewNavigationState' must not be null";
        return this.m_viewKeyToInitialState.get(new ViewKey(viewId, secondaryId));
    }

    public synchronized NavigationState getCurrentViewNavigationState(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getCurrentViewNavigationState' must not be null";
        return this.m_viewKeyToCurrentState.get(new ViewKey(viewId, secondaryId));
    }

    public synchronized void setCurrentViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'setCurrentViewNavigationState' must not be null";
        assert (this.m_viewKeyToInitialState.containsKey(state.getViewKey())) : "Has no initial state: " + String.valueOf(state.getViewKey());
        assert (this.getIndexOf(state) != -1) : "State not found for '" + String.valueOf(state.getViewKey()) + "': " + String.valueOf(state);
        this.m_viewKeyToCurrentState.put(state.getViewKey(), state);
    }

    public synchronized void removeNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'removeNavigationState' must not be null";
        NavigationState currentState = this.getCurrentNavigationState();
        assert (currentState != null) : "'currentState' of method 'removeNavigationState' must not be null";
        ViewKey viewKey = state.getViewKey();
        assert (this.m_viewKeyToInitialState.get(viewKey) != state) : "The initial view state cannot be removed: " + String.valueOf(viewKey);
        assert (this.m_viewKeyToCurrentState.get(viewKey) != state) : "The current view state cannot be removed: " + String.valueOf(viewKey);
        assert (currentState != state) : "The current state cannot be removed";
        int nextIndexToRemove = this.getIndexOf(state);
        assert (nextIndexToRemove != -1) : "No index of for state to remove: " + String.valueOf(state);
        this.m_states.remove(nextIndexToRemove);
        this.m_currentIndex = this.getIndexOf(currentState);
        assert (this.m_currentIndex != -1) : "No index of for: " + String.valueOf(currentState);
        this.m_accessor.navigationStatesRemoved(Collections.singletonList(state));
        this.m_accessor.navigationStatesChanged();
    }

    public synchronized NavigationState getCurrentNavigationState() {
        return this.m_states.isEmpty() ? null : this.m_states.get(this.m_currentIndex);
    }

    public synchronized boolean isEmpty() {
        return this.m_states.isEmpty();
    }

    public synchronized List<NavigationState> getViewNavigationStates(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getCurrentViewNavigationState' must not be null";
        ViewKey viewKey = new ViewKey(viewId, secondaryId);
        ArrayList<NavigationState> states = new ArrayList<NavigationState>();
        for (NavigationState nextState : this.m_states) {
            if (!nextState.getViewKey().equals(viewKey)) continue;
            states.add(nextState);
        }
        return states;
    }

    public synchronized List<NavigationState> getNavigationStates() {
        return Collections.unmodifiableList(this.m_states);
    }

    public synchronized List<NavigationState> getInitialViewNavigationStates() {
        return new ArrayList<NavigationState>(this.m_viewKeyToInitialState.values());
    }

    public synchronized List<NavigationState> getCurrentViewNavigationStates() {
        return new ArrayList<NavigationState>(this.m_viewKeyToCurrentState.values());
    }

    public synchronized boolean isInitialViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'isInitialViewNavigationState' must not be null";
        return this.m_viewKeyToInitialState.get(state.getViewKey()) == state;
    }

    public synchronized boolean isCurrentViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'isCurrentViewNavigationState' must not be null";
        return this.m_viewKeyToCurrentState.get(state.getViewKey()) == state;
    }

    public synchronized void clear() {
        if (!(this.m_states.isEmpty() && this.m_viewKeyToCurrentState.isEmpty() && this.m_viewKeyToInitialState.isEmpty())) {
            this.m_states.clear();
            this.m_viewKeyToInitialState.clear();
            this.m_viewKeyToCurrentState.clear();
            this.m_currentIndex = -1;
            this.m_accessor.navigationStatesChanged();
        }
    }

    public synchronized NavigationState clear(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'clear' must not be null";
        ViewKey viewKey = new ViewKey(viewId, secondaryId);
        LOGGER.debug("Clear navigation states of '" + String.valueOf(viewKey) + "'");
        NavigationState currentNavigationStateOfClearedView = this.m_viewKeyToCurrentState.remove(viewKey);
        this.m_viewKeyToInitialState.remove(viewKey);
        if (!this.m_states.isEmpty()) {
            ArrayList<NavigationState> removedStates = new ArrayList<NavigationState>();
            ArrayList<NavigationState> statesToProcess = new ArrayList<NavigationState>(this.m_states);
            this.m_states.clear();
            NavigationState lastTransferredSate = null;
            block5: for (NavigationState nextStateToProcess : statesToProcess) {
                if (nextStateToProcess.getViewKey().equals(viewKey)) {
                    removedStates.add(nextStateToProcess);
                    continue;
                }
                if (lastTransferredSate == null) {
                    this.m_states.add(nextStateToProcess);
                    lastTransferredSate = nextStateToProcess;
                    continue;
                }
                StateAction nextStateAction = this.determineStateAction(lastTransferredSate, nextStateToProcess);
                switch (nextStateAction) {
                    case DISCARD_SECOND: {
                        removedStates.add(nextStateToProcess);
                        break;
                    }
                    case REPLACE_FIRST: {
                        NavigationState replaced = this.m_states.set(this.m_states.size() - 1, nextStateToProcess);
                        lastTransferredSate = nextStateToProcess;
                        removedStates.add(replaced);
                        break;
                    }
                    case ADD_SECOND: {
                        this.m_states.add(nextStateToProcess);
                        lastTransferredSate = nextStateToProcess;
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled state action: " + String.valueOf((Object)nextStateAction);
                        continue block5;
                    }
                }
            }
            if (this.m_states.isEmpty()) {
                this.m_currentIndex = -1;
                this.checkCurrentIndexIntegrity(viewKey);
            } else {
                this.m_currentIndex = this.m_states.size() - 1;
                this.checkCurrentIndexIntegrity(viewKey);
            }
            if (!removedStates.isEmpty()) {
                this.m_accessor.navigationStatesRemoved(removedStates);
            }
            this.m_accessor.navigationStatesChanged();
        }
        LOGGER.debug("Clear navigation states of '" + String.valueOf(viewKey) + "' - done");
        return currentNavigationStateOfClearedView;
    }

    static enum StateAction {
        REPLACE_FIRST,
        DISCARD_SECOND,
        ADD_SECOND;

    }
}

