/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.IndexBasedTextSearchHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TreeItem;

public final class TreeBasedTextSearchHandler
extends IndexBasedTextSearchHandler<TreeItem> {
    private final TreeViewer m_treeViewer;

    public TreeBasedTextSearchHandler(TreeViewer treeViewer, String connectedTo) {
        super(connectedTo);
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'TreeBasedTextSearchProvider' must not be null";
        this.m_treeViewer = treeViewer;
    }

    @Override
    public boolean canConnect() {
        return !this.m_treeViewer.getTree().isDisposed();
    }

    @Override
    protected List<TreeItem> getSortedElementsForSearch() {
        ArrayList<TreeItem> sortedItemsForSearch = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.m_treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (!treeItem.isDisposed()) {
                sortedItemsForSearch.add(treeItem);
                this.collectChildren(treeItem, sortedItemsForSearch);
            }
            ++n2;
        }
        return sortedItemsForSearch;
    }

    private void collectChildren(TreeItem parent, List<TreeItem> collector) {
        assert (parent != null) : "Parameter 'parent' of method 'collectChildren' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectChildren' must not be null";
        TreeItem[] treeItemArray = parent.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (!treeItem.isDisposed()) {
                collector.add(treeItem);
                this.collectChildren(treeItem, collector);
            }
            ++n2;
        }
    }

    @Override
    protected void selectAndRevealForFind(TreeItem elementToSelectAndReveal) {
        assert (false) : "Not to be called";
    }

    @Override
    protected String getTextForTextSearch(TreeItem elementForTextSearch) {
        assert (false) : "Not to be called";
        return null;
    }

    @Override
    protected int calculatePositionForFind() {
        List<TreeItem> sortedElementsForSearch = this.getSortedElementsForSearch();
        int selectedTopIndex = -1;
        Pair firstSelectedElement = null;
        TreeItem[] treeItemArray = this.m_treeViewer.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int itemIndex = sortedElementsForSearch.indexOf(item);
            assert (itemIndex >= 0) : "'item' should be contained in the sorted elements for search";
            if (selectedTopIndex == -1) {
                selectedTopIndex = itemIndex;
                firstSelectedElement = new Pair((Object)item, (Object)itemIndex);
            } else if ((selectedTopIndex = Math.min(selectedTopIndex, itemIndex)) == itemIndex) {
                firstSelectedElement = new Pair((Object)item, (Object)itemIndex);
            }
            ++n2;
        }
        if (selectedTopIndex == -1 || firstSelectedElement == null) {
            return 0;
        }
        int i = 0;
        for (Object element : TreeBasedTextSearchHandler.collectElementsFromInput(this.m_treeViewer)) {
            if (((TreeItem)firstSelectedElement.getFirst()).getData() == element) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected int find(int currentIndex, String searchText, boolean caseSensitive, boolean wholeWord, boolean regex) {
        assert (searchText != null && !searchText.isEmpty()) : "Parameter 'searchText' of method 'find' must not be empty";
        List<Object> elementsForSearch = TreeBasedTextSearchHandler.collectElementsFromInput(this.m_treeViewer);
        if (elementsForSearch.isEmpty()) {
            return 0;
        }
        Object elementForTextSearch = elementsForSearch.get(currentIndex);
        String content = this.getTextForTextSearchFromElement(elementForTextSearch);
        Matcher matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regex);
        Pair<Integer, Boolean> findResult = new Pair<Integer, Boolean>((Object)currentIndex, (Object)false);
        int infoForSearch = currentIndex;
        boolean allInputSearched = false;
        while (!((Boolean)findResult.getSecond()).booleanValue()) {
            findResult = this.find(elementsForSearch, infoForSearch, content, searchText, matcher, true);
            if (!allInputSearched && !((Boolean)findResult.getSecond()).booleanValue() && (Integer)findResult.getFirst() == currentIndex) {
                allInputSearched = true;
            }
            if (allInputSearched) break;
            if (((Boolean)findResult.getSecond()).booleanValue()) continue;
            infoForSearch = (Integer)findResult.getFirst();
            Object next = elementsForSearch.get(infoForSearch);
            content = this.getTextForTextSearchFromElement(next);
            matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regex);
        }
        return (Integer)findResult.getFirst();
    }

    private final Pair<Integer, Boolean> find(List<Object> elements, int currentIndex, String content, String searchText, Matcher matcher, boolean setSelection) {
        assert (elements != null) : "Parameter 'nodes' of method 'find' must not be null";
        assert (content != null) : "Parameter 'content' of method 'find' must not be null";
        assert (searchText != null) : "Parameter 'searchText' of method 'find' must not be null";
        assert (matcher != null) : "Parameter 'matcher' of method 'find' must not be null";
        int itemsLength = elements.size();
        assert (currentIndex >= 0 && currentIndex < itemsLength) : "";
        if (matcher.find(0)) {
            if (setSelection) {
                Object match = elements.get(currentIndex);
                this.m_treeViewer.getTree().setRedraw(false);
                TreePath path = TreeBasedTextSearchHandler.createTreePath(this.m_treeViewer, match);
                this.m_treeViewer.setSelection((ISelection)new TreeSelection(path), true);
                this.m_treeViewer.getTree().setRedraw(true);
            }
            currentIndex = currentIndex == itemsLength - 1 ? 0 : ++currentIndex;
            return new Pair((Object)currentIndex, (Object)true);
        }
        if (currentIndex == itemsLength - 1) {
            return new Pair((Object)0, (Object)false);
        }
        return new Pair((Object)(currentIndex + 1), (Object)false);
    }

    private static TreePath createTreePath(TreeViewer treeViewer, Object match) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'createTreePath' must not be null";
        assert (match != null) : "Parameter 'match' of method 'createTreePath' must not be null";
        ITreeContentProvider contentProvider = TreeBasedTextSearchHandler.getContentProvider(treeViewer);
        ArrayList<Object> path = new ArrayList<Object>();
        TreeBasedTextSearchHandler.addParentsRecursively(contentProvider, path, match);
        return new TreePath(path.toArray());
    }

    private static void addParentsRecursively(ITreeContentProvider contentProvider, List<Object> path, Object element) {
        assert (path != null) : "Parameter 'path' of method 'addParentsRecursively' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addParentsRecursively' must not be null";
        path.add(0, element);
        Object parent = contentProvider.getParent(element);
        if (parent != null) {
            TreeBasedTextSearchHandler.addParentsRecursively(contentProvider, path, parent);
        }
    }

    private String getTextForTextSearchFromElement(Object elementForTextSearch) {
        assert (elementForTextSearch != null) : "Parameter 'elementForTextSearch' of method 'getTextForTextSearchFromElement' must not be null";
        List<ColumnLabelProvider> labelProviders = TreeBasedTextSearchHandler.getLabelProviders(this.m_treeViewer);
        StringBuilder textForSearch = new StringBuilder();
        for (ColumnLabelProvider nextLabelProvider : labelProviders) {
            textForSearch.append(nextLabelProvider.getText(elementForTextSearch));
            textForSearch.append(" ");
        }
        return textForSearch.toString();
    }

    private static List<Object> collectElementsFromInput(TreeViewer treeViewer) {
        Object input = treeViewer.getInput();
        assert (input instanceof NamedElement || input instanceof Collection) : "Unsupported input of treeviewer for search: " + input.getClass().getCanonicalName();
        ITreeContentProvider treeContentProvider = TreeBasedTextSearchHandler.getContentProvider(treeViewer);
        Object[] elements = treeContentProvider.getElements(input);
        ArrayList<Object> allElements = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            TreeBasedTextSearchHandler.collectRecursively(next, allElements, treeContentProvider);
            ++n2;
        }
        if (treeViewer.getComparator() != null) {
            ViewerComparator viewerComparator = treeViewer.getComparator();
            GlobalTreeElementsComparator comparator = new GlobalTreeElementsComparator(treeViewer, viewerComparator);
            Collections.sort(allElements, comparator);
        }
        return allElements;
    }

    private static void collectRecursively(Object element, List<Object> allElements, ITreeContentProvider treeContentProvider) {
        assert (element != null) : "Parameter 'element' of method 'collectRecursively' must not be null";
        assert (allElements != null) : "Parameter 'allElements' of method 'collectRecursively' must not be null";
        assert (treeContentProvider != null) : "Parameter 'treeContentProvider' of method 'collectRecursively' must not be null";
        allElements.add(element);
        if (treeContentProvider.hasChildren(element)) {
            Object[] objectArray = treeContentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                TreeBasedTextSearchHandler.collectRecursively(next, allElements, treeContentProvider);
                ++n2;
            }
        }
    }

    private static ITreeContentProvider getContentProvider(TreeViewer treeViewer) {
        IContentProvider contentProvider = treeViewer.getContentProvider();
        assert (contentProvider != null && contentProvider instanceof ITreeContentProvider) : "Unexpected class in method 'collectElements': " + String.valueOf(contentProvider);
        return (ITreeContentProvider)contentProvider;
    }

    private static List<ColumnLabelProvider> getLabelProviders(TreeViewer treeViewer) {
        CellLabelProvider next;
        ArrayList<ColumnLabelProvider> result = new ArrayList<ColumnLabelProvider>();
        int i = 0;
        while ((next = treeViewer.getLabelProvider(i)) != null) {
            if (next instanceof ColumnLabelProvider) {
                result.add((ColumnLabelProvider)next);
            }
            ++i;
        }
        return result;
    }

    private static class GlobalTreeElementsComparator
    implements Comparator<Object> {
        private final ViewerComparator m_viewerComparator;
        private final TreeViewer m_treeViewer;

        public GlobalTreeElementsComparator(TreeViewer treeViewer, ViewerComparator viewerComparator) {
            assert (treeViewer != null) : "Parameter 'treeViewer' of method 'GlobalTreeElementsComparator' must not be null";
            assert (viewerComparator != null) : "Parameter 'viewerComparator' of method 'GlobalTreeElementsComparator' must not be null";
            this.m_treeViewer = treeViewer;
            this.m_viewerComparator = viewerComparator;
        }

        @Override
        public int compare(Object e1, Object e2) {
            Object[] path2;
            Object[] path1 = this.getParentsIncludingSelf((Viewer)this.m_treeViewer, e1);
            int shortestPath = path1.length <= (path2 = this.getParentsIncludingSelf((Viewer)this.m_treeViewer, e2)).length ? path1.length : path2.length;
            int result = 0;
            int i = 0;
            while (i < shortestPath) {
                Object o1 = path1[i];
                Object o2 = path2[i];
                if (o1 != o2 && (result = this.m_viewerComparator.compare((Viewer)this.m_treeViewer, o1, o2)) != 0) {
                    return result;
                }
                ++i;
            }
            if (i == shortestPath && path1.length != path2.length) {
                return path2.length - path1.length;
            }
            return this.m_viewerComparator.compare((Viewer)this.m_treeViewer, e1, e2);
        }

        private Object[] getParentsIncludingSelf(Viewer viewer, Object object) {
            assert (viewer != null) : "Parameter 'viewer' of method 'getLevel' must not be null";
            assert (viewer instanceof TreeViewer) : "Unexpected class in method 'getLevel': " + viewer.getClass().getCanonicalName();
            assert (object != null) : "Parameter 'object' of method 'getLevel' must not be null";
            IContentProvider contentProvider = ((TreeViewer)viewer).getContentProvider();
            assert (contentProvider != null) : "ContentProvider must not be null";
            assert (contentProvider instanceof ITreeContentProvider) : "Unexpected class in method 'getLevel': " + contentProvider.getClass().getCanonicalName();
            ITreeContentProvider treeContentProvider = (ITreeContentProvider)contentProvider;
            ArrayList<Object> path = new ArrayList<Object>();
            this.calculatePath(path, treeContentProvider, object);
            return path.toArray();
        }

        private void calculatePath(List<Object> path, ITreeContentProvider treeContentProvider, Object object) {
            assert (path != null) : "Parameter 'path' of method 'calculatePath' must not be null";
            assert (treeContentProvider != null) : "Parameter 'treeContentProvider' of method 'calculatePath' must not be null";
            assert (object != null) : "Parameter 'object' of method 'calculatePath' must not be null";
            path.add(0, object);
            Object parent = treeContentProvider.getParent(object);
            if (parent != null) {
                this.calculatePath(path, treeContentProvider, parent);
            }
        }
    }
}

